// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.SwapResourceProperties;
import java.io.IOException;

/**
 * SwapResource to represent slot type on the specified cloud service.
 */
@Fluent
public final class SwapResourceInner implements JsonSerializable<SwapResourceInner> {
    /*
     * Resource Id.
     */
    private String id;

    /*
     * Resource name.
     */
    private String name;

    /*
     * Resource type.
     */
    private String type;

    /*
     * Swap resource properties
     */
    private SwapResourceProperties properties;

    /**
     * Creates an instance of SwapResourceInner class.
     */
    public SwapResourceInner() {
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Resource name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the properties property: Swap resource properties.
     * 
     * @return the properties value.
     */
    public SwapResourceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Swap resource properties.
     * 
     * @param properties the properties value to set.
     * @return the SwapResourceInner object itself.
     */
    public SwapResourceInner withProperties(SwapResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SwapResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SwapResourceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SwapResourceInner.
     */
    public static SwapResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SwapResourceInner deserializedSwapResourceInner = new SwapResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSwapResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSwapResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSwapResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSwapResourceInner.properties = SwapResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSwapResourceInner;
        });
    }
}
