// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of ServiceAssociationLink.
 */
@Fluent
public final class ServiceAssociationLinkPropertiesFormat
    implements JsonSerializable<ServiceAssociationLinkPropertiesFormat> {
    /*
     * Resource type of the linked resource.
     */
    private String linkedResourceType;

    /*
     * Link to the external resource.
     */
    private String link;

    /*
     * The provisioning state of the service association link resource.
     */
    private ProvisioningState provisioningState;

    /*
     * If true, the resource can be deleted.
     */
    private Boolean allowDelete;

    /*
     * A list of locations.
     */
    private List<String> locations;

    /**
     * Creates an instance of ServiceAssociationLinkPropertiesFormat class.
     */
    public ServiceAssociationLinkPropertiesFormat() {
    }

    /**
     * Get the linkedResourceType property: Resource type of the linked resource.
     * 
     * @return the linkedResourceType value.
     */
    public String linkedResourceType() {
        return this.linkedResourceType;
    }

    /**
     * Set the linkedResourceType property: Resource type of the linked resource.
     * 
     * @param linkedResourceType the linkedResourceType value to set.
     * @return the ServiceAssociationLinkPropertiesFormat object itself.
     */
    public ServiceAssociationLinkPropertiesFormat withLinkedResourceType(String linkedResourceType) {
        this.linkedResourceType = linkedResourceType;
        return this;
    }

    /**
     * Get the link property: Link to the external resource.
     * 
     * @return the link value.
     */
    public String link() {
        return this.link;
    }

    /**
     * Set the link property: Link to the external resource.
     * 
     * @param link the link value to set.
     * @return the ServiceAssociationLinkPropertiesFormat object itself.
     */
    public ServiceAssociationLinkPropertiesFormat withLink(String link) {
        this.link = link;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the service association link resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the allowDelete property: If true, the resource can be deleted.
     * 
     * @return the allowDelete value.
     */
    public Boolean allowDelete() {
        return this.allowDelete;
    }

    /**
     * Set the allowDelete property: If true, the resource can be deleted.
     * 
     * @param allowDelete the allowDelete value to set.
     * @return the ServiceAssociationLinkPropertiesFormat object itself.
     */
    public ServiceAssociationLinkPropertiesFormat withAllowDelete(Boolean allowDelete) {
        this.allowDelete = allowDelete;
        return this;
    }

    /**
     * Get the locations property: A list of locations.
     * 
     * @return the locations value.
     */
    public List<String> locations() {
        return this.locations;
    }

    /**
     * Set the locations property: A list of locations.
     * 
     * @param locations the locations value to set.
     * @return the ServiceAssociationLinkPropertiesFormat object itself.
     */
    public ServiceAssociationLinkPropertiesFormat withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("linkedResourceType", this.linkedResourceType);
        jsonWriter.writeStringField("link", this.link);
        jsonWriter.writeBooleanField("allowDelete", this.allowDelete);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceAssociationLinkPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceAssociationLinkPropertiesFormat if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceAssociationLinkPropertiesFormat.
     */
    public static ServiceAssociationLinkPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceAssociationLinkPropertiesFormat deserializedServiceAssociationLinkPropertiesFormat
                = new ServiceAssociationLinkPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("linkedResourceType".equals(fieldName)) {
                    deserializedServiceAssociationLinkPropertiesFormat.linkedResourceType = reader.getString();
                } else if ("link".equals(fieldName)) {
                    deserializedServiceAssociationLinkPropertiesFormat.link = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedServiceAssociationLinkPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("allowDelete".equals(fieldName)) {
                    deserializedServiceAssociationLinkPropertiesFormat.allowDelete
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedServiceAssociationLinkPropertiesFormat.locations = locations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceAssociationLinkPropertiesFormat;
        });
    }
}
