// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityUserGroupItem;
import java.io.IOException;
import java.util.List;

/**
 * Defines the security user rule collection properties.
 */
@Fluent
public final class SecurityUserRuleCollectionPropertiesFormat
    implements JsonSerializable<SecurityUserRuleCollectionPropertiesFormat> {
    /*
     * A description of the security user rule collection.
     */
    private String description;

    /*
     * Groups for configuration
     */
    private List<SecurityUserGroupItem> appliesToGroups;

    /*
     * The provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Unique identifier for this resource.
     */
    private String resourceGuid;

    /**
     * Creates an instance of SecurityUserRuleCollectionPropertiesFormat class.
     */
    public SecurityUserRuleCollectionPropertiesFormat() {
    }

    /**
     * Get the description property: A description of the security user rule collection.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the security user rule collection.
     * 
     * @param description the description value to set.
     * @return the SecurityUserRuleCollectionPropertiesFormat object itself.
     */
    public SecurityUserRuleCollectionPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the appliesToGroups property: Groups for configuration.
     * 
     * @return the appliesToGroups value.
     */
    public List<SecurityUserGroupItem> appliesToGroups() {
        return this.appliesToGroups;
    }

    /**
     * Set the appliesToGroups property: Groups for configuration.
     * 
     * @param appliesToGroups the appliesToGroups value to set.
     * @return the SecurityUserRuleCollectionPropertiesFormat object itself.
     */
    public SecurityUserRuleCollectionPropertiesFormat withAppliesToGroups(List<SecurityUserGroupItem> appliesToGroups) {
        this.appliesToGroups = appliesToGroups;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (appliesToGroups() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property appliesToGroups in model SecurityUserRuleCollectionPropertiesFormat"));
        } else {
            appliesToGroups().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SecurityUserRuleCollectionPropertiesFormat.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("appliesToGroups", this.appliesToGroups,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityUserRuleCollectionPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityUserRuleCollectionPropertiesFormat if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SecurityUserRuleCollectionPropertiesFormat.
     */
    public static SecurityUserRuleCollectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityUserRuleCollectionPropertiesFormat deserializedSecurityUserRuleCollectionPropertiesFormat
                = new SecurityUserRuleCollectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appliesToGroups".equals(fieldName)) {
                    List<SecurityUserGroupItem> appliesToGroups
                        = reader.readArray(reader1 -> SecurityUserGroupItem.fromJson(reader1));
                    deserializedSecurityUserRuleCollectionPropertiesFormat.appliesToGroups = appliesToGroups;
                } else if ("description".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionPropertiesFormat.description = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionPropertiesFormat.resourceGuid = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityUserRuleCollectionPropertiesFormat;
        });
    }
}
