// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AssociationAccessMode;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import java.io.IOException;

/**
 * The NspAssociationProperties model.
 */
@Fluent
public final class NspAssociationProperties implements JsonSerializable<NspAssociationProperties> {
    /*
     * The provisioning state of the resource association resource.
     */
    private NspProvisioningState provisioningState;

    /*
     * The PaaS resource to be associated.
     */
    private SubResource privateLinkResource;

    /*
     * Profile id to which the PaaS resource is associated.
     */
    private SubResource profile;

    /*
     * Access mode on the association.
     */
    private AssociationAccessMode accessMode;

    /*
     * Specifies if there are provisioning issues
     */
    private String hasProvisioningIssues;

    /**
     * Creates an instance of NspAssociationProperties class.
     */
    public NspAssociationProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource association resource.
     * 
     * @return the provisioningState value.
     */
    public NspProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateLinkResource property: The PaaS resource to be associated.
     * 
     * @return the privateLinkResource value.
     */
    public SubResource privateLinkResource() {
        return this.privateLinkResource;
    }

    /**
     * Set the privateLinkResource property: The PaaS resource to be associated.
     * 
     * @param privateLinkResource the privateLinkResource value to set.
     * @return the NspAssociationProperties object itself.
     */
    public NspAssociationProperties withPrivateLinkResource(SubResource privateLinkResource) {
        this.privateLinkResource = privateLinkResource;
        return this;
    }

    /**
     * Get the profile property: Profile id to which the PaaS resource is associated.
     * 
     * @return the profile value.
     */
    public SubResource profile() {
        return this.profile;
    }

    /**
     * Set the profile property: Profile id to which the PaaS resource is associated.
     * 
     * @param profile the profile value to set.
     * @return the NspAssociationProperties object itself.
     */
    public NspAssociationProperties withProfile(SubResource profile) {
        this.profile = profile;
        return this;
    }

    /**
     * Get the accessMode property: Access mode on the association.
     * 
     * @return the accessMode value.
     */
    public AssociationAccessMode accessMode() {
        return this.accessMode;
    }

    /**
     * Set the accessMode property: Access mode on the association.
     * 
     * @param accessMode the accessMode value to set.
     * @return the NspAssociationProperties object itself.
     */
    public NspAssociationProperties withAccessMode(AssociationAccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    /**
     * Get the hasProvisioningIssues property: Specifies if there are provisioning issues.
     * 
     * @return the hasProvisioningIssues value.
     */
    public String hasProvisioningIssues() {
        return this.hasProvisioningIssues;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateLinkResource", this.privateLinkResource);
        jsonWriter.writeJsonField("profile", this.profile);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspAssociationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspAssociationProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspAssociationProperties.
     */
    public static NspAssociationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspAssociationProperties deserializedNspAssociationProperties = new NspAssociationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedNspAssociationProperties.provisioningState
                        = NspProvisioningState.fromString(reader.getString());
                } else if ("privateLinkResource".equals(fieldName)) {
                    deserializedNspAssociationProperties.privateLinkResource = SubResource.fromJson(reader);
                } else if ("profile".equals(fieldName)) {
                    deserializedNspAssociationProperties.profile = SubResource.fromJson(reader);
                } else if ("accessMode".equals(fieldName)) {
                    deserializedNspAssociationProperties.accessMode
                        = AssociationAccessMode.fromString(reader.getString());
                } else if ("hasProvisioningIssues".equals(fieldName)) {
                    deserializedNspAssociationProperties.hasProvisioningIssues = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspAssociationProperties;
        });
    }
}
