// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AssociationAccessMode;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;

/**
 * The NSP resource association resource.
 */
@Fluent
public final class NspAssociationInner extends SecurityPerimeterProxyResource {
    /*
     * Properties of the NSP resource association.
     */
    private NspAssociationProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SecurityPerimeterSystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NspAssociationInner class.
     */
    public NspAssociationInner() {
    }

    /**
     * Get the innerProperties property: Properties of the NSP resource association.
     * 
     * @return the innerProperties value.
     */
    private NspAssociationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource association resource.
     * 
     * @return the provisioningState value.
     */
    public NspProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the privateLinkResource property: The PaaS resource to be associated.
     * 
     * @return the privateLinkResource value.
     */
    public SubResource privateLinkResource() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkResource();
    }

    /**
     * Set the privateLinkResource property: The PaaS resource to be associated.
     * 
     * @param privateLinkResource the privateLinkResource value to set.
     * @return the NspAssociationInner object itself.
     */
    public NspAssociationInner withPrivateLinkResource(SubResource privateLinkResource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAssociationProperties();
        }
        this.innerProperties().withPrivateLinkResource(privateLinkResource);
        return this;
    }

    /**
     * Get the profile property: Profile id to which the PaaS resource is associated.
     * 
     * @return the profile value.
     */
    public SubResource profile() {
        return this.innerProperties() == null ? null : this.innerProperties().profile();
    }

    /**
     * Set the profile property: Profile id to which the PaaS resource is associated.
     * 
     * @param profile the profile value to set.
     * @return the NspAssociationInner object itself.
     */
    public NspAssociationInner withProfile(SubResource profile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAssociationProperties();
        }
        this.innerProperties().withProfile(profile);
        return this;
    }

    /**
     * Get the accessMode property: Access mode on the association.
     * 
     * @return the accessMode value.
     */
    public AssociationAccessMode accessMode() {
        return this.innerProperties() == null ? null : this.innerProperties().accessMode();
    }

    /**
     * Set the accessMode property: Access mode on the association.
     * 
     * @param accessMode the accessMode value to set.
     * @return the NspAssociationInner object itself.
     */
    public NspAssociationInner withAccessMode(AssociationAccessMode accessMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAssociationProperties();
        }
        this.innerProperties().withAccessMode(accessMode);
        return this;
    }

    /**
     * Get the hasProvisioningIssues property: Specifies if there are provisioning issues.
     * 
     * @return the hasProvisioningIssues value.
     */
    public String hasProvisioningIssues() {
        return this.innerProperties() == null ? null : this.innerProperties().hasProvisioningIssues();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (systemData() != null) {
            systemData().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspAssociationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspAssociationInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NspAssociationInner.
     */
    public static NspAssociationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspAssociationInner deserializedNspAssociationInner = new NspAssociationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNspAssociationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNspAssociationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNspAssociationInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedNspAssociationInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedNspAssociationInner.innerProperties = NspAssociationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspAssociationInner;
        });
    }
}
