// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NextHopType;
import java.io.IOException;

/**
 * The information about next hop from the specified VM.
 */
@Fluent
public final class NextHopResultInner implements JsonSerializable<NextHopResultInner> {
    /*
     * Next hop type.
     */
    private NextHopType nextHopType;

    /*
     * Next hop IP Address.
     */
    private String nextHopIpAddress;

    /*
     * The resource identifier for the route table associated with the route being returned. If the route being returned
     * does not correspond to any user created routes then this field will be the string 'System Route'.
     */
    private String routeTableId;

    /**
     * Creates an instance of NextHopResultInner class.
     */
    public NextHopResultInner() {
    }

    /**
     * Get the nextHopType property: Next hop type.
     * 
     * @return the nextHopType value.
     */
    public NextHopType nextHopType() {
        return this.nextHopType;
    }

    /**
     * Set the nextHopType property: Next hop type.
     * 
     * @param nextHopType the nextHopType value to set.
     * @return the NextHopResultInner object itself.
     */
    public NextHopResultInner withNextHopType(NextHopType nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    /**
     * Get the nextHopIpAddress property: Next hop IP Address.
     * 
     * @return the nextHopIpAddress value.
     */
    public String nextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    /**
     * Set the nextHopIpAddress property: Next hop IP Address.
     * 
     * @param nextHopIpAddress the nextHopIpAddress value to set.
     * @return the NextHopResultInner object itself.
     */
    public NextHopResultInner withNextHopIpAddress(String nextHopIpAddress) {
        this.nextHopIpAddress = nextHopIpAddress;
        return this;
    }

    /**
     * Get the routeTableId property: The resource identifier for the route table associated with the route being
     * returned. If the route being returned does not correspond to any user created routes then this field will be the
     * string 'System Route'.
     * 
     * @return the routeTableId value.
     */
    public String routeTableId() {
        return this.routeTableId;
    }

    /**
     * Set the routeTableId property: The resource identifier for the route table associated with the route being
     * returned. If the route being returned does not correspond to any user created routes then this field will be the
     * string 'System Route'.
     * 
     * @param routeTableId the routeTableId value to set.
     * @return the NextHopResultInner object itself.
     */
    public NextHopResultInner withRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextHopType", this.nextHopType == null ? null : this.nextHopType.toString());
        jsonWriter.writeStringField("nextHopIpAddress", this.nextHopIpAddress);
        jsonWriter.writeStringField("routeTableId", this.routeTableId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NextHopResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NextHopResultInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NextHopResultInner.
     */
    public static NextHopResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NextHopResultInner deserializedNextHopResultInner = new NextHopResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nextHopType".equals(fieldName)) {
                    deserializedNextHopResultInner.nextHopType = NextHopType.fromString(reader.getString());
                } else if ("nextHopIpAddress".equals(fieldName)) {
                    deserializedNextHopResultInner.nextHopIpAddress = reader.getString();
                } else if ("routeTableId".equals(fieldName)) {
                    deserializedNextHopResultInner.routeTableId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNextHopResultInner;
        });
    }
}
