// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ContainerNetworkInterface;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Network profile properties.
 */
@Fluent
public final class NetworkProfilePropertiesFormat implements JsonSerializable<NetworkProfilePropertiesFormat> {
    /*
     * List of child container network interfaces.
     */
    private List<ContainerNetworkInterface> containerNetworkInterfaces;

    /*
     * List of chid container network interface configurations.
     */
    private List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations;

    /*
     * The resource GUID property of the network profile resource.
     */
    private String resourceGuid;

    /*
     * The provisioning state of the network profile resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of NetworkProfilePropertiesFormat class.
     */
    public NetworkProfilePropertiesFormat() {
    }

    /**
     * Get the containerNetworkInterfaces property: List of child container network interfaces.
     * 
     * @return the containerNetworkInterfaces value.
     */
    public List<ContainerNetworkInterface> containerNetworkInterfaces() {
        return this.containerNetworkInterfaces;
    }

    /**
     * Get the containerNetworkInterfaceConfigurations property: List of chid container network interface
     * configurations.
     * 
     * @return the containerNetworkInterfaceConfigurations value.
     */
    public List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations() {
        return this.containerNetworkInterfaceConfigurations;
    }

    /**
     * Set the containerNetworkInterfaceConfigurations property: List of chid container network interface
     * configurations.
     * 
     * @param containerNetworkInterfaceConfigurations the containerNetworkInterfaceConfigurations value to set.
     * @return the NetworkProfilePropertiesFormat object itself.
     */
    public NetworkProfilePropertiesFormat withContainerNetworkInterfaceConfigurations(
        List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations) {
        this.containerNetworkInterfaceConfigurations = containerNetworkInterfaceConfigurations;
        return this;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the network profile resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioningState property: The provisioning state of the network profile resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (containerNetworkInterfaces() != null) {
            containerNetworkInterfaces().forEach(e -> e.validate());
        }
        if (containerNetworkInterfaceConfigurations() != null) {
            containerNetworkInterfaceConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("containerNetworkInterfaceConfigurations",
            this.containerNetworkInterfaceConfigurations, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkProfilePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkProfilePropertiesFormat if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkProfilePropertiesFormat.
     */
    public static NetworkProfilePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkProfilePropertiesFormat deserializedNetworkProfilePropertiesFormat
                = new NetworkProfilePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("containerNetworkInterfaces".equals(fieldName)) {
                    List<ContainerNetworkInterface> containerNetworkInterfaces
                        = reader.readArray(reader1 -> ContainerNetworkInterface.fromJson(reader1));
                    deserializedNetworkProfilePropertiesFormat.containerNetworkInterfaces = containerNetworkInterfaces;
                } else if ("containerNetworkInterfaceConfigurations".equals(fieldName)) {
                    List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations
                        = reader.readArray(reader1 -> ContainerNetworkInterfaceConfiguration.fromJson(reader1));
                    deserializedNetworkProfilePropertiesFormat.containerNetworkInterfaceConfigurations
                        = containerNetworkInterfaceConfigurations;
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedNetworkProfilePropertiesFormat.resourceGuid = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkProfilePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkProfilePropertiesFormat;
        });
    }
}
