// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * LocalNetworkGateway properties.
 */
@Fluent
public final class LocalNetworkGatewayPropertiesFormat
    implements JsonSerializable<LocalNetworkGatewayPropertiesFormat> {
    /*
     * Local network site address space.
     */
    private AddressSpace localNetworkAddressSpace;

    /*
     * IP address of local network gateway.
     */
    private String gatewayIpAddress;

    /*
     * FQDN of local network gateway.
     */
    private String fqdn;

    /*
     * Local network gateway's BGP speaker settings.
     */
    private BgpSettings bgpSettings;

    /*
     * The resource GUID property of the local network gateway resource.
     */
    private String resourceGuid;

    /*
     * The provisioning state of the local network gateway resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of LocalNetworkGatewayPropertiesFormat class.
     */
    public LocalNetworkGatewayPropertiesFormat() {
    }

    /**
     * Get the localNetworkAddressSpace property: Local network site address space.
     * 
     * @return the localNetworkAddressSpace value.
     */
    public AddressSpace localNetworkAddressSpace() {
        return this.localNetworkAddressSpace;
    }

    /**
     * Set the localNetworkAddressSpace property: Local network site address space.
     * 
     * @param localNetworkAddressSpace the localNetworkAddressSpace value to set.
     * @return the LocalNetworkGatewayPropertiesFormat object itself.
     */
    public LocalNetworkGatewayPropertiesFormat withLocalNetworkAddressSpace(AddressSpace localNetworkAddressSpace) {
        this.localNetworkAddressSpace = localNetworkAddressSpace;
        return this;
    }

    /**
     * Get the gatewayIpAddress property: IP address of local network gateway.
     * 
     * @return the gatewayIpAddress value.
     */
    public String gatewayIpAddress() {
        return this.gatewayIpAddress;
    }

    /**
     * Set the gatewayIpAddress property: IP address of local network gateway.
     * 
     * @param gatewayIpAddress the gatewayIpAddress value to set.
     * @return the LocalNetworkGatewayPropertiesFormat object itself.
     */
    public LocalNetworkGatewayPropertiesFormat withGatewayIpAddress(String gatewayIpAddress) {
        this.gatewayIpAddress = gatewayIpAddress;
        return this;
    }

    /**
     * Get the fqdn property: FQDN of local network gateway.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Set the fqdn property: FQDN of local network gateway.
     * 
     * @param fqdn the fqdn value to set.
     * @return the LocalNetworkGatewayPropertiesFormat object itself.
     */
    public LocalNetworkGatewayPropertiesFormat withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    /**
     * Get the bgpSettings property: Local network gateway's BGP speaker settings.
     * 
     * @return the bgpSettings value.
     */
    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    /**
     * Set the bgpSettings property: Local network gateway's BGP speaker settings.
     * 
     * @param bgpSettings the bgpSettings value to set.
     * @return the LocalNetworkGatewayPropertiesFormat object itself.
     */
    public LocalNetworkGatewayPropertiesFormat withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the local network gateway resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioningState property: The provisioning state of the local network gateway resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (localNetworkAddressSpace() != null) {
            localNetworkAddressSpace().validate();
        }
        if (bgpSettings() != null) {
            bgpSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("localNetworkAddressSpace", this.localNetworkAddressSpace);
        jsonWriter.writeStringField("gatewayIpAddress", this.gatewayIpAddress);
        jsonWriter.writeStringField("fqdn", this.fqdn);
        jsonWriter.writeJsonField("bgpSettings", this.bgpSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocalNetworkGatewayPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocalNetworkGatewayPropertiesFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocalNetworkGatewayPropertiesFormat.
     */
    public static LocalNetworkGatewayPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocalNetworkGatewayPropertiesFormat deserializedLocalNetworkGatewayPropertiesFormat
                = new LocalNetworkGatewayPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("localNetworkAddressSpace".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.localNetworkAddressSpace
                        = AddressSpace.fromJson(reader);
                } else if ("gatewayIpAddress".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.gatewayIpAddress = reader.getString();
                } else if ("fqdn".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.fqdn = reader.getString();
                } else if ("bgpSettings".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.bgpSettings = BgpSettings.fromJson(reader);
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.resourceGuid = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocalNetworkGatewayPropertiesFormat;
        });
    }
}
