// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddress;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of Backend Address Pool of an application gateway.
 */
@Fluent
public final class ApplicationGatewayBackendAddressPoolPropertiesFormat
    implements JsonSerializable<ApplicationGatewayBackendAddressPoolPropertiesFormat> {
    /*
     * Collection of references to IPs defined in network interfaces.
     */
    private List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations;

    /*
     * Backend addresses.
     */
    private List<ApplicationGatewayBackendAddress> backendAddresses;

    /*
     * The provisioning state of the backend address pool resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayBackendAddressPoolPropertiesFormat class.
     */
    public ApplicationGatewayBackendAddressPoolPropertiesFormat() {
    }

    /**
     * Get the backendIpConfigurations property: Collection of references to IPs defined in network interfaces.
     * 
     * @return the backendIpConfigurations value.
     */
    public List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations() {
        return this.backendIpConfigurations;
    }

    /**
     * Get the backendAddresses property: Backend addresses.
     * 
     * @return the backendAddresses value.
     */
    public List<ApplicationGatewayBackendAddress> backendAddresses() {
        return this.backendAddresses;
    }

    /**
     * Set the backendAddresses property: Backend addresses.
     * 
     * @param backendAddresses the backendAddresses value to set.
     * @return the ApplicationGatewayBackendAddressPoolPropertiesFormat object itself.
     */
    public ApplicationGatewayBackendAddressPoolPropertiesFormat
        withBackendAddresses(List<ApplicationGatewayBackendAddress> backendAddresses) {
        this.backendAddresses = backendAddresses;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the backend address pool resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (backendIpConfigurations() != null) {
            backendIpConfigurations().forEach(e -> e.validate());
        }
        if (backendAddresses() != null) {
            backendAddresses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("backendAddresses", this.backendAddresses,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayBackendAddressPoolPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayBackendAddressPoolPropertiesFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayBackendAddressPoolPropertiesFormat.
     */
    public static ApplicationGatewayBackendAddressPoolPropertiesFormat fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayBackendAddressPoolPropertiesFormat deserializedApplicationGatewayBackendAddressPoolPropertiesFormat
                = new ApplicationGatewayBackendAddressPoolPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("backendIPConfigurations".equals(fieldName)) {
                    List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations
                        = reader.readArray(reader1 -> NetworkInterfaceIpConfigurationInner.fromJson(reader1));
                    deserializedApplicationGatewayBackendAddressPoolPropertiesFormat.backendIpConfigurations
                        = backendIpConfigurations;
                } else if ("backendAddresses".equals(fieldName)) {
                    List<ApplicationGatewayBackendAddress> backendAddresses
                        = reader.readArray(reader1 -> ApplicationGatewayBackendAddress.fromJson(reader1));
                    deserializedApplicationGatewayBackendAddressPoolPropertiesFormat.backendAddresses
                        = backendAddresses;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayBackendAddressPoolPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayBackendAddressPoolPropertiesFormat;
        });
    }
}
