// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.network.fluent.models.ReachabilityAnalysisIntentInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ReachabilityAnalysisIntentsClient.
 */
public interface ReachabilityAnalysisIntentsClient {
    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ReachabilityAnalysisIntentInner> listAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue);

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ReachabilityAnalysisIntentInner> listAsync(String resourceGroupName, String networkManagerName,
        String workspaceName);

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ReachabilityAnalysisIntentInner> list(String resourceGroupName, String networkManagerName,
        String workspaceName);

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ReachabilityAnalysisIntentInner> list(String resourceGroupName, String networkManagerName,
        String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue,
        Context context);

    /**
     * Get the Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Reachability Analysis Intent along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ReachabilityAnalysisIntentInner>> getWithResponseAsync(String resourceGroupName,
        String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName);

    /**
     * Get the Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Reachability Analysis Intent on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ReachabilityAnalysisIntentInner> getAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName);

    /**
     * Get the Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Reachability Analysis Intent along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ReachabilityAnalysisIntentInner> getWithResponse(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName, Context context);

    /**
     * Get the Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Reachability Analysis Intent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ReachabilityAnalysisIntentInner get(String resourceGroupName, String networkManagerName, String workspaceName,
        String reachabilityAnalysisIntentName);

    /**
     * Creates Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param body Reachability Analysis Intent object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration information or intent on which to do the analysis on along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ReachabilityAnalysisIntentInner>> createWithResponseAsync(String resourceGroupName,
        String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName,
        ReachabilityAnalysisIntentInner body);

    /**
     * Creates Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param body Reachability Analysis Intent object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration information or intent on which to do the analysis on on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ReachabilityAnalysisIntentInner> createAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body);

    /**
     * Creates Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param body Reachability Analysis Intent object to create/update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration information or intent on which to do the analysis on along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ReachabilityAnalysisIntentInner> createWithResponse(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body,
        Context context);

    /**
     * Creates Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param body Reachability Analysis Intent object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration information or intent on which to do the analysis on.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ReachabilityAnalysisIntentInner create(String resourceGroupName, String networkManagerName, String workspaceName,
        String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body);

    /**
     * Deletes Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName);

    /**
     * Deletes Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String workspaceName,
        String reachabilityAnalysisIntentName);

    /**
     * Deletes Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String networkManagerName, String workspaceName,
        String reachabilityAnalysisIntentName, Context context);

    /**
     * Deletes Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkManagerName, String workspaceName,
        String reachabilityAnalysisIntentName);
}
