// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.network.fluent.models.NspServiceTagsResourceInner;

/**
 * An instance of this class provides access to all the operations defined in NetworkSecurityPerimeterServiceTagsClient.
 */
public interface NetworkSecurityPerimeterServiceTagsClient {
    /**
     * Gets the list of service tags supported by NSP. These service tags can be used to create access rules in NSP.
     * 
     * @param location The location of network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of service tags supported by NSP as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NspServiceTagsResourceInner> listAsync(String location);

    /**
     * Gets the list of service tags supported by NSP. These service tags can be used to create access rules in NSP.
     * 
     * @param location The location of network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of service tags supported by NSP as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NspServiceTagsResourceInner> list(String location);

    /**
     * Gets the list of service tags supported by NSP. These service tags can be used to create access rules in NSP.
     * 
     * @param location The location of network security perimeter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of service tags supported by NSP as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NspServiceTagsResourceInner> list(String location, Context context);
}
