/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class NetworkInterfaceDnsSettings
implements JsonSerializable<NetworkInterfaceDnsSettings> {
    private List<String> dnsServers;
    private List<String> appliedDnsServers;
    private String internalDnsNameLabel;
    private String internalFqdn;
    private String internalDomainNameSuffix;

    public List<String> dnsServers() {
        return this.dnsServers;
    }

    public NetworkInterfaceDnsSettings withDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
        return this;
    }

    public List<String> appliedDnsServers() {
        return this.appliedDnsServers;
    }

    public String internalDnsNameLabel() {
        return this.internalDnsNameLabel;
    }

    public NetworkInterfaceDnsSettings withInternalDnsNameLabel(String internalDnsNameLabel) {
        this.internalDnsNameLabel = internalDnsNameLabel;
        return this;
    }

    public String internalFqdn() {
        return this.internalFqdn;
    }

    public String internalDomainNameSuffix() {
        return this.internalDomainNameSuffix;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dnsServers", this.dnsServers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("internalDnsNameLabel", this.internalDnsNameLabel);
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfaceDnsSettings fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfaceDnsSettings)jsonReader.readObject(reader -> {
            NetworkInterfaceDnsSettings deserializedNetworkInterfaceDnsSettings = new NetworkInterfaceDnsSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dnsServers".equals(fieldName)) {
                    List dnsServers;
                    deserializedNetworkInterfaceDnsSettings.dnsServers = dnsServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("appliedDnsServers".equals(fieldName)) {
                    List appliedDnsServers;
                    deserializedNetworkInterfaceDnsSettings.appliedDnsServers = appliedDnsServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("internalDnsNameLabel".equals(fieldName)) {
                    deserializedNetworkInterfaceDnsSettings.internalDnsNameLabel = reader.getString();
                    continue;
                }
                if ("internalFqdn".equals(fieldName)) {
                    deserializedNetworkInterfaceDnsSettings.internalFqdn = reader.getString();
                    continue;
                }
                if ("internalDomainNameSuffix".equals(fieldName)) {
                    deserializedNetworkInterfaceDnsSettings.internalDomainNameSuffix = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfaceDnsSettings;
        });
    }
}

