/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.MatchVariable;
import com.azure.resourcemanager.network.models.WebApplicationFirewallOperator;
import com.azure.resourcemanager.network.models.WebApplicationFirewallTransform;
import java.io.IOException;
import java.util.List;

public final class MatchCondition
implements JsonSerializable<MatchCondition> {
    private List<MatchVariable> matchVariables;
    private WebApplicationFirewallOperator operator;
    private Boolean negationConditon;
    private List<String> matchValues;
    private List<WebApplicationFirewallTransform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(MatchCondition.class);

    public List<MatchVariable> matchVariables() {
        return this.matchVariables;
    }

    public MatchCondition withMatchVariables(List<MatchVariable> matchVariables) {
        this.matchVariables = matchVariables;
        return this;
    }

    public WebApplicationFirewallOperator operator() {
        return this.operator;
    }

    public MatchCondition withOperator(WebApplicationFirewallOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negationConditon() {
        return this.negationConditon;
    }

    public MatchCondition withNegationConditon(Boolean negationConditon) {
        this.negationConditon = negationConditon;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public MatchCondition withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<WebApplicationFirewallTransform> transforms() {
        return this.transforms;
    }

    public MatchCondition withTransforms(List<WebApplicationFirewallTransform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.matchVariables() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property matchVariables in model MatchCondition"));
        }
        this.matchVariables().forEach(e -> e.validate());
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model MatchCondition"));
        }
        if (this.matchValues() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property matchValues in model MatchCondition"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("matchVariables", this.matchVariables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("negationConditon", this.negationConditon);
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static MatchCondition fromJson(JsonReader jsonReader) throws IOException {
        return (MatchCondition)jsonReader.readObject(reader -> {
            MatchCondition deserializedMatchCondition = new MatchCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("matchVariables".equals(fieldName)) {
                    List matchVariables;
                    deserializedMatchCondition.matchVariables = matchVariables = reader.readArray(reader1 -> MatchVariable.fromJson(reader1));
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedMatchCondition.operator = WebApplicationFirewallOperator.fromString(reader.getString());
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List matchValues;
                    deserializedMatchCondition.matchValues = matchValues = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("negationConditon".equals(fieldName)) {
                    deserializedMatchCondition.negationConditon = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List transforms;
                    deserializedMatchCondition.transforms = transforms = reader.readArray(reader1 -> WebApplicationFirewallTransform.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMatchCondition;
        });
    }
}

