// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Migration status for the Virtual Network Gateway.
 */
@Fluent
public final class VirtualNetworkGatewayMigrationStatus
    implements JsonSerializable<VirtualNetworkGatewayMigrationStatus> {
    /*
     * Represent the current state of gateway migration.
     */
    private VirtualNetworkGatewayMigrationState state;

    /*
     * Represent the current migration phase of gateway.
     */
    private VirtualNetworkGatewayMigrationPhase phase;

    /*
     * Error if any occurs during migration.
     */
    private String errorMessage;

    /**
     * Creates an instance of VirtualNetworkGatewayMigrationStatus class.
     */
    public VirtualNetworkGatewayMigrationStatus() {
    }

    /**
     * Get the state property: Represent the current state of gateway migration.
     * 
     * @return the state value.
     */
    public VirtualNetworkGatewayMigrationState state() {
        return this.state;
    }

    /**
     * Set the state property: Represent the current state of gateway migration.
     * 
     * @param state the state value to set.
     * @return the VirtualNetworkGatewayMigrationStatus object itself.
     */
    public VirtualNetworkGatewayMigrationStatus withState(VirtualNetworkGatewayMigrationState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the phase property: Represent the current migration phase of gateway.
     * 
     * @return the phase value.
     */
    public VirtualNetworkGatewayMigrationPhase phase() {
        return this.phase;
    }

    /**
     * Set the phase property: Represent the current migration phase of gateway.
     * 
     * @param phase the phase value to set.
     * @return the VirtualNetworkGatewayMigrationStatus object itself.
     */
    public VirtualNetworkGatewayMigrationStatus withPhase(VirtualNetworkGatewayMigrationPhase phase) {
        this.phase = phase;
        return this;
    }

    /**
     * Get the errorMessage property: Error if any occurs during migration.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Set the errorMessage property: Error if any occurs during migration.
     * 
     * @param errorMessage the errorMessage value to set.
     * @return the VirtualNetworkGatewayMigrationStatus object itself.
     */
    public VirtualNetworkGatewayMigrationStatus withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("phase", this.phase == null ? null : this.phase.toString());
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewayMigrationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewayMigrationStatus if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewayMigrationStatus.
     */
    public static VirtualNetworkGatewayMigrationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayMigrationStatus deserializedVirtualNetworkGatewayMigrationStatus
                = new VirtualNetworkGatewayMigrationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayMigrationStatus.state
                        = VirtualNetworkGatewayMigrationState.fromString(reader.getString());
                } else if ("phase".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayMigrationStatus.phase
                        = VirtualNetworkGatewayMigrationPhase.fromString(reader.getString());
                } else if ("errorMessage".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayMigrationStatus.errorMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewayMigrationStatus;
        });
    }
}
