// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Virtual network gateway migration parameters.
 */
@Fluent
public final class VirtualNetworkGatewayMigrationParameters
    implements JsonSerializable<VirtualNetworkGatewayMigrationParameters> {
    /*
     * MigrationType for the virtual network gateway.
     */
    private VirtualNetworkGatewayMigrationType migrationType;

    /*
     * Resource url that needs to be passed in to migration.
     */
    private String resourceUrl;

    /**
     * Creates an instance of VirtualNetworkGatewayMigrationParameters class.
     */
    public VirtualNetworkGatewayMigrationParameters() {
    }

    /**
     * Get the migrationType property: MigrationType for the virtual network gateway.
     * 
     * @return the migrationType value.
     */
    public VirtualNetworkGatewayMigrationType migrationType() {
        return this.migrationType;
    }

    /**
     * Set the migrationType property: MigrationType for the virtual network gateway.
     * 
     * @param migrationType the migrationType value to set.
     * @return the VirtualNetworkGatewayMigrationParameters object itself.
     */
    public VirtualNetworkGatewayMigrationParameters
        withMigrationType(VirtualNetworkGatewayMigrationType migrationType) {
        this.migrationType = migrationType;
        return this;
    }

    /**
     * Get the resourceUrl property: Resource url that needs to be passed in to migration.
     * 
     * @return the resourceUrl value.
     */
    public String resourceUrl() {
        return this.resourceUrl;
    }

    /**
     * Set the resourceUrl property: Resource url that needs to be passed in to migration.
     * 
     * @param resourceUrl the resourceUrl value to set.
     * @return the VirtualNetworkGatewayMigrationParameters object itself.
     */
    public VirtualNetworkGatewayMigrationParameters withResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (migrationType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property migrationType in model VirtualNetworkGatewayMigrationParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkGatewayMigrationParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("migrationType", this.migrationType == null ? null : this.migrationType.toString());
        jsonWriter.writeStringField("resourceUrl", this.resourceUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewayMigrationParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewayMigrationParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewayMigrationParameters.
     */
    public static VirtualNetworkGatewayMigrationParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayMigrationParameters deserializedVirtualNetworkGatewayMigrationParameters
                = new VirtualNetworkGatewayMigrationParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("migrationType".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayMigrationParameters.migrationType
                        = VirtualNetworkGatewayMigrationType.fromString(reader.getString());
                } else if ("resourceUrl".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayMigrationParameters.resourceUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewayMigrationParameters;
        });
    }
}
