// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Gateway Resiliency based Recommendations.
 */
@Fluent
public final class ResiliencyRecommendationComponents implements JsonSerializable<ResiliencyRecommendationComponents> {
    /*
     * Name of the Resiliency based Recommendation Component
     */
    private String name;

    /*
     * Current Score of the gateway
     */
    private String currentScore;

    /*
     * Max score that the gateway can achieve if the specified recommendation is applied
     */
    private String maxScore;

    /*
     * List of Gateway Resiliency based Recommendations
     */
    private List<GatewayResiliencyRecommendation> recommendations;

    /**
     * Creates an instance of ResiliencyRecommendationComponents class.
     */
    public ResiliencyRecommendationComponents() {
    }

    /**
     * Get the name property: Name of the Resiliency based Recommendation Component.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Resiliency based Recommendation Component.
     * 
     * @param name the name value to set.
     * @return the ResiliencyRecommendationComponents object itself.
     */
    public ResiliencyRecommendationComponents withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the currentScore property: Current Score of the gateway.
     * 
     * @return the currentScore value.
     */
    public String currentScore() {
        return this.currentScore;
    }

    /**
     * Set the currentScore property: Current Score of the gateway.
     * 
     * @param currentScore the currentScore value to set.
     * @return the ResiliencyRecommendationComponents object itself.
     */
    public ResiliencyRecommendationComponents withCurrentScore(String currentScore) {
        this.currentScore = currentScore;
        return this;
    }

    /**
     * Get the maxScore property: Max score that the gateway can achieve if the specified recommendation is applied.
     * 
     * @return the maxScore value.
     */
    public String maxScore() {
        return this.maxScore;
    }

    /**
     * Set the maxScore property: Max score that the gateway can achieve if the specified recommendation is applied.
     * 
     * @param maxScore the maxScore value to set.
     * @return the ResiliencyRecommendationComponents object itself.
     */
    public ResiliencyRecommendationComponents withMaxScore(String maxScore) {
        this.maxScore = maxScore;
        return this;
    }

    /**
     * Get the recommendations property: List of Gateway Resiliency based Recommendations.
     * 
     * @return the recommendations value.
     */
    public List<GatewayResiliencyRecommendation> recommendations() {
        return this.recommendations;
    }

    /**
     * Set the recommendations property: List of Gateway Resiliency based Recommendations.
     * 
     * @param recommendations the recommendations value to set.
     * @return the ResiliencyRecommendationComponents object itself.
     */
    public ResiliencyRecommendationComponents
        withRecommendations(List<GatewayResiliencyRecommendation> recommendations) {
        this.recommendations = recommendations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (recommendations() != null) {
            recommendations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("currentScore", this.currentScore);
        jsonWriter.writeStringField("maxScore", this.maxScore);
        jsonWriter.writeArrayField("recommendations", this.recommendations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResiliencyRecommendationComponents from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResiliencyRecommendationComponents if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResiliencyRecommendationComponents.
     */
    public static ResiliencyRecommendationComponents fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResiliencyRecommendationComponents deserializedResiliencyRecommendationComponents
                = new ResiliencyRecommendationComponents();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedResiliencyRecommendationComponents.name = reader.getString();
                } else if ("currentScore".equals(fieldName)) {
                    deserializedResiliencyRecommendationComponents.currentScore = reader.getString();
                } else if ("maxScore".equals(fieldName)) {
                    deserializedResiliencyRecommendationComponents.maxScore = reader.getString();
                } else if ("recommendations".equals(fieldName)) {
                    List<GatewayResiliencyRecommendation> recommendations
                        = reader.readArray(reader1 -> GatewayResiliencyRecommendation.fromJson(reader1));
                    deserializedResiliencyRecommendationComponents.recommendations = recommendations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResiliencyRecommendationComponents;
        });
    }
}
