// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Network Protocol.
 */
public final class NetworkProtocol extends ExpandableStringEnum<NetworkProtocol> {
    /**
     * Static value Any for NetworkProtocol.
     */
    public static final NetworkProtocol ANY = fromString("Any");

    /**
     * Static value TCP for NetworkProtocol.
     */
    public static final NetworkProtocol TCP = fromString("TCP");

    /**
     * Static value UDP for NetworkProtocol.
     */
    public static final NetworkProtocol UDP = fromString("UDP");

    /**
     * Static value ICMP for NetworkProtocol.
     */
    public static final NetworkProtocol ICMP = fromString("ICMP");

    /**
     * Creates a new instance of NetworkProtocol value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NetworkProtocol() {
    }

    /**
     * Creates or finds a NetworkProtocol from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NetworkProtocol.
     */
    public static NetworkProtocol fromString(String name) {
        return fromString(name, NetworkProtocol.class);
    }

    /**
     * Gets known NetworkProtocol values.
     * 
     * @return known NetworkProtocol values.
     */
    public static Collection<NetworkProtocol> values() {
        return values(NetworkProtocol.class);
    }
}
