// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Network Manager Deployment Status Parameter.
 */
@Fluent
public final class NetworkManagerDeploymentStatusParameter
    implements JsonSerializable<NetworkManagerDeploymentStatusParameter> {
    /*
     * List of locations.
     */
    private List<String> regions;

    /*
     * List of deployment types.
     */
    private List<ConfigurationType> deploymentTypes;

    /*
     * Continuation token for pagination, capturing the next page size and offset, as well as the context of the query.
     */
    private String skipToken;

    /**
     * Creates an instance of NetworkManagerDeploymentStatusParameter class.
     */
    public NetworkManagerDeploymentStatusParameter() {
    }

    /**
     * Get the regions property: List of locations.
     * 
     * @return the regions value.
     */
    public List<String> regions() {
        return this.regions;
    }

    /**
     * Set the regions property: List of locations.
     * 
     * @param regions the regions value to set.
     * @return the NetworkManagerDeploymentStatusParameter object itself.
     */
    public NetworkManagerDeploymentStatusParameter withRegions(List<String> regions) {
        this.regions = regions;
        return this;
    }

    /**
     * Get the deploymentTypes property: List of deployment types.
     * 
     * @return the deploymentTypes value.
     */
    public List<ConfigurationType> deploymentTypes() {
        return this.deploymentTypes;
    }

    /**
     * Set the deploymentTypes property: List of deployment types.
     * 
     * @param deploymentTypes the deploymentTypes value to set.
     * @return the NetworkManagerDeploymentStatusParameter object itself.
     */
    public NetworkManagerDeploymentStatusParameter withDeploymentTypes(List<ConfigurationType> deploymentTypes) {
        this.deploymentTypes = deploymentTypes;
        return this;
    }

    /**
     * Get the skipToken property: Continuation token for pagination, capturing the next page size and offset, as well
     * as the context of the query.
     * 
     * @return the skipToken value.
     */
    public String skipToken() {
        return this.skipToken;
    }

    /**
     * Set the skipToken property: Continuation token for pagination, capturing the next page size and offset, as well
     * as the context of the query.
     * 
     * @param skipToken the skipToken value to set.
     * @return the NetworkManagerDeploymentStatusParameter object itself.
     */
    public NetworkManagerDeploymentStatusParameter withSkipToken(String skipToken) {
        this.skipToken = skipToken;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("regions", this.regions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("deploymentTypes", this.deploymentTypes,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("skipToken", this.skipToken);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkManagerDeploymentStatusParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkManagerDeploymentStatusParameter if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkManagerDeploymentStatusParameter.
     */
    public static NetworkManagerDeploymentStatusParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkManagerDeploymentStatusParameter deserializedNetworkManagerDeploymentStatusParameter
                = new NetworkManagerDeploymentStatusParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("regions".equals(fieldName)) {
                    List<String> regions = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkManagerDeploymentStatusParameter.regions = regions;
                } else if ("deploymentTypes".equals(fieldName)) {
                    List<ConfigurationType> deploymentTypes
                        = reader.readArray(reader1 -> ConfigurationType.fromString(reader1.getString()));
                    deserializedNetworkManagerDeploymentStatusParameter.deploymentTypes = deploymentTypes;
                } else if ("skipToken".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatusParameter.skipToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkManagerDeploymentStatusParameter;
        });
    }
}
