// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListInboundNatRule API service call.
 */
@Fluent
public final class InboundNatRuleListResult implements JsonSerializable<InboundNatRuleListResult> {
    /*
     * A list of inbound NAT rules in a load balancer.
     */
    private List<InboundNatRuleInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of InboundNatRuleListResult class.
     */
    public InboundNatRuleListResult() {
    }

    /**
     * Get the value property: A list of inbound NAT rules in a load balancer.
     * 
     * @return the value value.
     */
    public List<InboundNatRuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of inbound NAT rules in a load balancer.
     * 
     * @param value the value value to set.
     * @return the InboundNatRuleListResult object itself.
     */
    public InboundNatRuleListResult withValue(List<InboundNatRuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InboundNatRuleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InboundNatRuleListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the InboundNatRuleListResult.
     */
    public static InboundNatRuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InboundNatRuleListResult deserializedInboundNatRuleListResult = new InboundNatRuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<InboundNatRuleInner> value
                        = reader.readArray(reader1 -> InboundNatRuleInner.fromJson(reader1));
                    deserializedInboundNatRuleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedInboundNatRuleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInboundNatRuleListResult;
        });
    }
}
