// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Results of network security group evaluation.
 */
@Fluent
public final class EvaluatedNetworkSecurityGroup implements JsonSerializable<EvaluatedNetworkSecurityGroup> {
    /*
     * Network security group ID.
     */
    private String networkSecurityGroupId;

    /*
     * Resource ID of nic or subnet to which network security group is applied.
     */
    private String appliedTo;

    /*
     * Matched network security rule.
     */
    private MatchedRule matchedRule;

    /*
     * List of network security rules evaluation results.
     */
    private List<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult;

    /**
     * Creates an instance of EvaluatedNetworkSecurityGroup class.
     */
    public EvaluatedNetworkSecurityGroup() {
    }

    /**
     * Get the networkSecurityGroupId property: Network security group ID.
     * 
     * @return the networkSecurityGroupId value.
     */
    public String networkSecurityGroupId() {
        return this.networkSecurityGroupId;
    }

    /**
     * Set the networkSecurityGroupId property: Network security group ID.
     * 
     * @param networkSecurityGroupId the networkSecurityGroupId value to set.
     * @return the EvaluatedNetworkSecurityGroup object itself.
     */
    public EvaluatedNetworkSecurityGroup withNetworkSecurityGroupId(String networkSecurityGroupId) {
        this.networkSecurityGroupId = networkSecurityGroupId;
        return this;
    }

    /**
     * Get the appliedTo property: Resource ID of nic or subnet to which network security group is applied.
     * 
     * @return the appliedTo value.
     */
    public String appliedTo() {
        return this.appliedTo;
    }

    /**
     * Set the appliedTo property: Resource ID of nic or subnet to which network security group is applied.
     * 
     * @param appliedTo the appliedTo value to set.
     * @return the EvaluatedNetworkSecurityGroup object itself.
     */
    public EvaluatedNetworkSecurityGroup withAppliedTo(String appliedTo) {
        this.appliedTo = appliedTo;
        return this;
    }

    /**
     * Get the matchedRule property: Matched network security rule.
     * 
     * @return the matchedRule value.
     */
    public MatchedRule matchedRule() {
        return this.matchedRule;
    }

    /**
     * Set the matchedRule property: Matched network security rule.
     * 
     * @param matchedRule the matchedRule value to set.
     * @return the EvaluatedNetworkSecurityGroup object itself.
     */
    public EvaluatedNetworkSecurityGroup withMatchedRule(MatchedRule matchedRule) {
        this.matchedRule = matchedRule;
        return this;
    }

    /**
     * Get the rulesEvaluationResult property: List of network security rules evaluation results.
     * 
     * @return the rulesEvaluationResult value.
     */
    public List<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult() {
        return this.rulesEvaluationResult;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (matchedRule() != null) {
            matchedRule().validate();
        }
        if (rulesEvaluationResult() != null) {
            rulesEvaluationResult().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkSecurityGroupId", this.networkSecurityGroupId);
        jsonWriter.writeStringField("appliedTo", this.appliedTo);
        jsonWriter.writeJsonField("matchedRule", this.matchedRule);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EvaluatedNetworkSecurityGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EvaluatedNetworkSecurityGroup if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EvaluatedNetworkSecurityGroup.
     */
    public static EvaluatedNetworkSecurityGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EvaluatedNetworkSecurityGroup deserializedEvaluatedNetworkSecurityGroup
                = new EvaluatedNetworkSecurityGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkSecurityGroupId".equals(fieldName)) {
                    deserializedEvaluatedNetworkSecurityGroup.networkSecurityGroupId = reader.getString();
                } else if ("appliedTo".equals(fieldName)) {
                    deserializedEvaluatedNetworkSecurityGroup.appliedTo = reader.getString();
                } else if ("matchedRule".equals(fieldName)) {
                    deserializedEvaluatedNetworkSecurityGroup.matchedRule = MatchedRule.fromJson(reader);
                } else if ("rulesEvaluationResult".equals(fieldName)) {
                    List<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult
                        = reader.readArray(reader1 -> NetworkSecurityRulesEvaluationResult.fromJson(reader1));
                    deserializedEvaluatedNetworkSecurityGroup.rulesEvaluationResult = rulesEvaluationResult;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEvaluatedNetworkSecurityGroup;
        });
    }
}
