// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Connectivity group item.
 */
@Fluent
public final class ConnectivityGroupItem implements JsonSerializable<ConnectivityGroupItem> {
    /*
     * Network group Id.
     */
    private String networkGroupId;

    /*
     * Flag if need to use hub gateway.
     */
    private UseHubGateway useHubGateway;

    /*
     * Flag if global is supported.
     */
    private IsGlobal isGlobal;

    /*
     * Group connectivity type.
     */
    private GroupConnectivity groupConnectivity;

    /**
     * Creates an instance of ConnectivityGroupItem class.
     */
    public ConnectivityGroupItem() {
    }

    /**
     * Get the networkGroupId property: Network group Id.
     * 
     * @return the networkGroupId value.
     */
    public String networkGroupId() {
        return this.networkGroupId;
    }

    /**
     * Set the networkGroupId property: Network group Id.
     * 
     * @param networkGroupId the networkGroupId value to set.
     * @return the ConnectivityGroupItem object itself.
     */
    public ConnectivityGroupItem withNetworkGroupId(String networkGroupId) {
        this.networkGroupId = networkGroupId;
        return this;
    }

    /**
     * Get the useHubGateway property: Flag if need to use hub gateway.
     * 
     * @return the useHubGateway value.
     */
    public UseHubGateway useHubGateway() {
        return this.useHubGateway;
    }

    /**
     * Set the useHubGateway property: Flag if need to use hub gateway.
     * 
     * @param useHubGateway the useHubGateway value to set.
     * @return the ConnectivityGroupItem object itself.
     */
    public ConnectivityGroupItem withUseHubGateway(UseHubGateway useHubGateway) {
        this.useHubGateway = useHubGateway;
        return this;
    }

    /**
     * Get the isGlobal property: Flag if global is supported.
     * 
     * @return the isGlobal value.
     */
    public IsGlobal isGlobal() {
        return this.isGlobal;
    }

    /**
     * Set the isGlobal property: Flag if global is supported.
     * 
     * @param isGlobal the isGlobal value to set.
     * @return the ConnectivityGroupItem object itself.
     */
    public ConnectivityGroupItem withIsGlobal(IsGlobal isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    /**
     * Get the groupConnectivity property: Group connectivity type.
     * 
     * @return the groupConnectivity value.
     */
    public GroupConnectivity groupConnectivity() {
        return this.groupConnectivity;
    }

    /**
     * Set the groupConnectivity property: Group connectivity type.
     * 
     * @param groupConnectivity the groupConnectivity value to set.
     * @return the ConnectivityGroupItem object itself.
     */
    public ConnectivityGroupItem withGroupConnectivity(GroupConnectivity groupConnectivity) {
        this.groupConnectivity = groupConnectivity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkGroupId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property networkGroupId in model ConnectivityGroupItem"));
        }
        if (groupConnectivity() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property groupConnectivity in model ConnectivityGroupItem"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityGroupItem.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkGroupId", this.networkGroupId);
        jsonWriter.writeStringField("groupConnectivity",
            this.groupConnectivity == null ? null : this.groupConnectivity.toString());
        jsonWriter.writeStringField("useHubGateway", this.useHubGateway == null ? null : this.useHubGateway.toString());
        jsonWriter.writeStringField("isGlobal", this.isGlobal == null ? null : this.isGlobal.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityGroupItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityGroupItem if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectivityGroupItem.
     */
    public static ConnectivityGroupItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityGroupItem deserializedConnectivityGroupItem = new ConnectivityGroupItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkGroupId".equals(fieldName)) {
                    deserializedConnectivityGroupItem.networkGroupId = reader.getString();
                } else if ("groupConnectivity".equals(fieldName)) {
                    deserializedConnectivityGroupItem.groupConnectivity
                        = GroupConnectivity.fromString(reader.getString());
                } else if ("useHubGateway".equals(fieldName)) {
                    deserializedConnectivityGroupItem.useHubGateway = UseHubGateway.fromString(reader.getString());
                } else if ("isGlobal".equals(fieldName)) {
                    deserializedConnectivityGroupItem.isGlobal = IsGlobal.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityGroupItem;
        });
    }
}
