// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Tracked Resource
 * 
 * The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a
 * 'location'.
 */
@Fluent
public class CommonTrackedResource extends CommonResource {
    /*
     * Resource tags.
     */
    private Map<String, String> tags;

    /*
     * The geo-location where the resource lives
     */
    private String location;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of CommonTrackedResource class.
     */
    public CommonTrackedResource() {
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the CommonTrackedResource object itself.
     */
    public CommonTrackedResource withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The geo-location where the resource lives.
     * 
     * @param location the location value to set.
     * @return the CommonTrackedResource object itself.
     */
    public CommonTrackedResource withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (location() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property location in model CommonTrackedResource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CommonTrackedResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CommonTrackedResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CommonTrackedResource if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CommonTrackedResource.
     */
    public static CommonTrackedResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CommonTrackedResource deserializedCommonTrackedResource = new CommonTrackedResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCommonTrackedResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedCommonTrackedResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCommonTrackedResource.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedCommonTrackedResource.systemData = SystemData.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedCommonTrackedResource.location = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCommonTrackedResource.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCommonTrackedResource;
        });
    }
}
