// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the AzureFirewallRCAction.
 */
@Fluent
public final class AzureFirewallRCAction implements JsonSerializable<AzureFirewallRCAction> {
    /*
     * The type of action.
     */
    private AzureFirewallRCActionType type;

    /**
     * Creates an instance of AzureFirewallRCAction class.
     */
    public AzureFirewallRCAction() {
    }

    /**
     * Get the type property: The type of action.
     * 
     * @return the type value.
     */
    public AzureFirewallRCActionType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of action.
     * 
     * @param type the type value to set.
     * @return the AzureFirewallRCAction object itself.
     */
    public AzureFirewallRCAction withType(AzureFirewallRCActionType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallRCAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallRCAction if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallRCAction.
     */
    public static AzureFirewallRCAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallRCAction deserializedAzureFirewallRCAction = new AzureFirewallRCAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedAzureFirewallRCAction.type = AzureFirewallRCActionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallRCAction;
        });
    }
}
