// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Application gateway probe health response match.
 */
@Fluent
public final class ApplicationGatewayProbeHealthResponseMatch
    implements JsonSerializable<ApplicationGatewayProbeHealthResponseMatch> {
    /*
     * Body that must be contained in the health response. Default value is empty.
     */
    private String body;

    /*
     * Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
     */
    private List<String> statusCodes;

    /**
     * Creates an instance of ApplicationGatewayProbeHealthResponseMatch class.
     */
    public ApplicationGatewayProbeHealthResponseMatch() {
    }

    /**
     * Get the body property: Body that must be contained in the health response. Default value is empty.
     * 
     * @return the body value.
     */
    public String body() {
        return this.body;
    }

    /**
     * Set the body property: Body that must be contained in the health response. Default value is empty.
     * 
     * @param body the body value to set.
     * @return the ApplicationGatewayProbeHealthResponseMatch object itself.
     */
    public ApplicationGatewayProbeHealthResponseMatch withBody(String body) {
        this.body = body;
        return this;
    }

    /**
     * Get the statusCodes property: Allowed ranges of healthy status codes. Default range of healthy status codes is
     * 200-399.
     * 
     * @return the statusCodes value.
     */
    public List<String> statusCodes() {
        return this.statusCodes;
    }

    /**
     * Set the statusCodes property: Allowed ranges of healthy status codes. Default range of healthy status codes is
     * 200-399.
     * 
     * @param statusCodes the statusCodes value to set.
     * @return the ApplicationGatewayProbeHealthResponseMatch object itself.
     */
    public ApplicationGatewayProbeHealthResponseMatch withStatusCodes(List<String> statusCodes) {
        this.statusCodes = statusCodes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeArrayField("statusCodes", this.statusCodes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayProbeHealthResponseMatch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayProbeHealthResponseMatch if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayProbeHealthResponseMatch.
     */
    public static ApplicationGatewayProbeHealthResponseMatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayProbeHealthResponseMatch deserializedApplicationGatewayProbeHealthResponseMatch
                = new ApplicationGatewayProbeHealthResponseMatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("body".equals(fieldName)) {
                    deserializedApplicationGatewayProbeHealthResponseMatch.body = reader.getString();
                } else if ("statusCodes".equals(fieldName)) {
                    List<String> statusCodes = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationGatewayProbeHealthResponseMatch.statusCodes = statusCodes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayProbeHealthResponseMatch;
        });
    }
}
