// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayBackendHealthServerInner;
import java.io.IOException;
import java.util.List;

/**
 * Application gateway BackendHealthHttp settings.
 */
@Fluent
public final class ApplicationGatewayBackendHealthHttpSettings
    implements JsonSerializable<ApplicationGatewayBackendHealthHttpSettings> {
    /*
     * Reference to an ApplicationGatewayBackendHttpSettings resource.
     */
    private ApplicationGatewayBackendHttpSettings backendHttpSettings;

    /*
     * List of ApplicationGatewayBackendHealthServer resources.
     */
    private List<ApplicationGatewayBackendHealthServerInner> servers;

    /**
     * Creates an instance of ApplicationGatewayBackendHealthHttpSettings class.
     */
    public ApplicationGatewayBackendHealthHttpSettings() {
    }

    /**
     * Get the backendHttpSettings property: Reference to an ApplicationGatewayBackendHttpSettings resource.
     * 
     * @return the backendHttpSettings value.
     */
    public ApplicationGatewayBackendHttpSettings backendHttpSettings() {
        return this.backendHttpSettings;
    }

    /**
     * Set the backendHttpSettings property: Reference to an ApplicationGatewayBackendHttpSettings resource.
     * 
     * @param backendHttpSettings the backendHttpSettings value to set.
     * @return the ApplicationGatewayBackendHealthHttpSettings object itself.
     */
    public ApplicationGatewayBackendHealthHttpSettings
        withBackendHttpSettings(ApplicationGatewayBackendHttpSettings backendHttpSettings) {
        this.backendHttpSettings = backendHttpSettings;
        return this;
    }

    /**
     * Get the servers property: List of ApplicationGatewayBackendHealthServer resources.
     * 
     * @return the servers value.
     */
    public List<ApplicationGatewayBackendHealthServerInner> servers() {
        return this.servers;
    }

    /**
     * Set the servers property: List of ApplicationGatewayBackendHealthServer resources.
     * 
     * @param servers the servers value to set.
     * @return the ApplicationGatewayBackendHealthHttpSettings object itself.
     */
    public ApplicationGatewayBackendHealthHttpSettings
        withServers(List<ApplicationGatewayBackendHealthServerInner> servers) {
        this.servers = servers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (backendHttpSettings() != null) {
            backendHttpSettings().validate();
        }
        if (servers() != null) {
            servers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backendHttpSettings", this.backendHttpSettings);
        jsonWriter.writeArrayField("servers", this.servers, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayBackendHealthHttpSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayBackendHealthHttpSettings if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayBackendHealthHttpSettings.
     */
    public static ApplicationGatewayBackendHealthHttpSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayBackendHealthHttpSettings deserializedApplicationGatewayBackendHealthHttpSettings
                = new ApplicationGatewayBackendHealthHttpSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("backendHttpSettings".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthHttpSettings.backendHttpSettings
                        = ApplicationGatewayBackendHttpSettings.fromJson(reader);
                } else if ("servers".equals(fieldName)) {
                    List<ApplicationGatewayBackendHealthServerInner> servers
                        = reader.readArray(reader1 -> ApplicationGatewayBackendHealthServerInner.fromJson(reader1));
                    deserializedApplicationGatewayBackendHealthHttpSettings.servers = servers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayBackendHealthHttpSettings;
        });
    }
}
