// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.AdminRuleCollectionInner;
import java.io.IOException;
import java.util.List;

/**
 * Security admin configuration rule collection list result.
 */
@Fluent
public final class AdminRuleCollectionListResult implements JsonSerializable<AdminRuleCollectionListResult> {
    /*
     * A list of network manager security admin configuration rule collections
     */
    private List<AdminRuleCollectionInner> value;

    /*
     * Gets the URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of AdminRuleCollectionListResult class.
     */
    public AdminRuleCollectionListResult() {
    }

    /**
     * Get the value property: A list of network manager security admin configuration rule collections.
     * 
     * @return the value value.
     */
    public List<AdminRuleCollectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of network manager security admin configuration rule collections.
     * 
     * @param value the value value to set.
     * @return the AdminRuleCollectionListResult object itself.
     */
    public AdminRuleCollectionListResult withValue(List<AdminRuleCollectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the AdminRuleCollectionListResult object itself.
     */
    public AdminRuleCollectionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdminRuleCollectionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdminRuleCollectionListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AdminRuleCollectionListResult.
     */
    public static AdminRuleCollectionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdminRuleCollectionListResult deserializedAdminRuleCollectionListResult
                = new AdminRuleCollectionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AdminRuleCollectionInner> value
                        = reader.readArray(reader1 -> AdminRuleCollectionInner.fromJson(reader1));
                    deserializedAdminRuleCollectionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAdminRuleCollectionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAdminRuleCollectionListResult;
        });
    }
}
