// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NspLinkProvisioningState;
import com.azure.resourcemanager.network.models.NspLinkStatus;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;
import java.util.List;

/**
 * The network security perimeter link resource.
 */
@Fluent
public final class NspLinkInner extends SecurityPerimeterProxyResource {
    /*
     * Properties of the network security perimeter link resource.
     */
    private NspLinkProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SecurityPerimeterSystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NspLinkInner class.
     */
    public NspLinkInner() {
    }

    /**
     * Get the innerProperties property: Properties of the network security perimeter link resource.
     * 
     * @return the innerProperties value.
     */
    private NspLinkProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: The provisioning state of the NSP Link resource.
     * 
     * @return the provisioningState value.
     */
    public NspLinkProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the autoApprovedRemotePerimeterResourceId property: Perimeter ARM Id for the remote NSP with which the link
     * gets created in Auto-approval mode. It should be used when the NSP admin have
     * Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote NSP resource.
     * 
     * @return the autoApprovedRemotePerimeterResourceId value.
     */
    public String autoApprovedRemotePerimeterResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().autoApprovedRemotePerimeterResourceId();
    }

    /**
     * Set the autoApprovedRemotePerimeterResourceId property: Perimeter ARM Id for the remote NSP with which the link
     * gets created in Auto-approval mode. It should be used when the NSP admin have
     * Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote NSP resource.
     * 
     * @param autoApprovedRemotePerimeterResourceId the autoApprovedRemotePerimeterResourceId value to set.
     * @return the NspLinkInner object itself.
     */
    public NspLinkInner withAutoApprovedRemotePerimeterResourceId(String autoApprovedRemotePerimeterResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkProperties();
        }
        this.innerProperties().withAutoApprovedRemotePerimeterResourceId(autoApprovedRemotePerimeterResourceId);
        return this;
    }

    /**
     * Get the remotePerimeterGuid property: Remote NSP Guid with which the link gets created.
     * 
     * @return the remotePerimeterGuid value.
     */
    public String remotePerimeterGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterGuid();
    }

    /**
     * Get the remotePerimeterLocation property: Remote NSP location with which the link gets created.
     * 
     * @return the remotePerimeterLocation value.
     */
    public String remotePerimeterLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterLocation();
    }

    /**
     * Get the localInboundProfiles property: Local Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles.
     * 
     * @return the localInboundProfiles value.
     */
    public List<String> localInboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().localInboundProfiles();
    }

    /**
     * Set the localInboundProfiles property: Local Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles.
     * 
     * @param localInboundProfiles the localInboundProfiles value to set.
     * @return the NspLinkInner object itself.
     */
    public NspLinkInner withLocalInboundProfiles(List<String> localInboundProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkProperties();
        }
        this.innerProperties().withLocalInboundProfiles(localInboundProfiles);
        return this;
    }

    /**
     * Get the localOutboundProfiles property: Local Outbound profile names from which Outbound is allowed. In current
     * version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later
     * version, user will be able to modify it.
     * 
     * @return the localOutboundProfiles value.
     */
    public List<String> localOutboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().localOutboundProfiles();
    }

    /**
     * Get the remoteInboundProfiles property: Remote Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles. This property can only be updated in auto-approval mode.
     * 
     * @return the remoteInboundProfiles value.
     */
    public List<String> remoteInboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteInboundProfiles();
    }

    /**
     * Set the remoteInboundProfiles property: Remote Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles. This property can only be updated in auto-approval mode.
     * 
     * @param remoteInboundProfiles the remoteInboundProfiles value to set.
     * @return the NspLinkInner object itself.
     */
    public NspLinkInner withRemoteInboundProfiles(List<String> remoteInboundProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkProperties();
        }
        this.innerProperties().withRemoteInboundProfiles(remoteInboundProfiles);
        return this;
    }

    /**
     * Get the remoteOutboundProfiles property: Remote Outbound profile names from which Outbound is allowed. In current
     * version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later
     * version, user will be able to modify it.
     * 
     * @return the remoteOutboundProfiles value.
     */
    public List<String> remoteOutboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteOutboundProfiles();
    }

    /**
     * Get the description property: A message passed to the owner of the remote NSP link resource with this connection
     * request. In case of Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: A message passed to the owner of the remote NSP link resource with this connection
     * request. In case of Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
     * 
     * @param description the description value to set.
     * @return the NspLinkInner object itself.
     */
    public NspLinkInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the status property: The NSP link state.
     * 
     * @return the status value.
     */
    public NspLinkStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (systemData() != null) {
            systemData().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspLinkInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspLinkInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NspLinkInner.
     */
    public static NspLinkInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspLinkInner deserializedNspLinkInner = new NspLinkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNspLinkInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNspLinkInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNspLinkInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedNspLinkInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedNspLinkInner.innerProperties = NspLinkProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspLinkInner;
        });
    }
}
