// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddressPool;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHealthHttpSettings;
import java.io.IOException;

/**
 * Result of on demand test probe.
 */
@Fluent
public final class ApplicationGatewayBackendHealthOnDemandInner
    implements JsonSerializable<ApplicationGatewayBackendHealthOnDemandInner> {
    /*
     * Reference to an ApplicationGatewayBackendAddressPool resource.
     */
    private ApplicationGatewayBackendAddressPool backendAddressPool;

    /*
     * Application gateway BackendHealthHttp settings.
     */
    private ApplicationGatewayBackendHealthHttpSettings backendHealthHttpSettings;

    /**
     * Creates an instance of ApplicationGatewayBackendHealthOnDemandInner class.
     */
    public ApplicationGatewayBackendHealthOnDemandInner() {
    }

    /**
     * Get the backendAddressPool property: Reference to an ApplicationGatewayBackendAddressPool resource.
     * 
     * @return the backendAddressPool value.
     */
    public ApplicationGatewayBackendAddressPool backendAddressPool() {
        return this.backendAddressPool;
    }

    /**
     * Set the backendAddressPool property: Reference to an ApplicationGatewayBackendAddressPool resource.
     * 
     * @param backendAddressPool the backendAddressPool value to set.
     * @return the ApplicationGatewayBackendHealthOnDemandInner object itself.
     */
    public ApplicationGatewayBackendHealthOnDemandInner
        withBackendAddressPool(ApplicationGatewayBackendAddressPool backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    /**
     * Get the backendHealthHttpSettings property: Application gateway BackendHealthHttp settings.
     * 
     * @return the backendHealthHttpSettings value.
     */
    public ApplicationGatewayBackendHealthHttpSettings backendHealthHttpSettings() {
        return this.backendHealthHttpSettings;
    }

    /**
     * Set the backendHealthHttpSettings property: Application gateway BackendHealthHttp settings.
     * 
     * @param backendHealthHttpSettings the backendHealthHttpSettings value to set.
     * @return the ApplicationGatewayBackendHealthOnDemandInner object itself.
     */
    public ApplicationGatewayBackendHealthOnDemandInner
        withBackendHealthHttpSettings(ApplicationGatewayBackendHealthHttpSettings backendHealthHttpSettings) {
        this.backendHealthHttpSettings = backendHealthHttpSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (backendAddressPool() != null) {
            backendAddressPool().validate();
        }
        if (backendHealthHttpSettings() != null) {
            backendHealthHttpSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backendAddressPool", this.backendAddressPool);
        jsonWriter.writeJsonField("backendHealthHttpSettings", this.backendHealthHttpSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayBackendHealthOnDemandInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayBackendHealthOnDemandInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayBackendHealthOnDemandInner.
     */
    public static ApplicationGatewayBackendHealthOnDemandInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayBackendHealthOnDemandInner deserializedApplicationGatewayBackendHealthOnDemandInner
                = new ApplicationGatewayBackendHealthOnDemandInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("backendAddressPool".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthOnDemandInner.backendAddressPool
                        = ApplicationGatewayBackendAddressPool.fromJson(reader);
                } else if ("backendHealthHttpSettings".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthOnDemandInner.backendHealthHttpSettings
                        = ApplicationGatewayBackendHealthHttpSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayBackendHealthOnDemandInner;
        });
    }
}
