/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.NetworkSecurityGroupsClient;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.implementation.NetworkSecurityGroupImpl;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.NetworkSecurityGroups;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class NetworkSecurityGroupsImpl
extends TopLevelModifiableResourcesImpl<NetworkSecurityGroup, NetworkSecurityGroupImpl, NetworkSecurityGroupInner, NetworkSecurityGroupsClient, NetworkManager>
implements NetworkSecurityGroups {
    public NetworkSecurityGroupsImpl(NetworkManager networkManager) {
        super((InnerSupportsListing)((NetworkManagementClient)networkManager.serviceClient()).getNetworkSecurityGroups(), (Manager)networkManager);
    }

    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return this.getByResourceGroupAsync(resourceGroupName, name).flatMapMany(nsg -> Flux.fromIterable(nsg.networkInterfaceIds()).flatMap(nicRef -> ((NetworkManager)this.manager()).networkInterfaces().getByIdAsync((String)nicRef)).flatMap(nic -> {
            if (nic == null) {
                return Mono.empty();
            }
            if (!nsg.id().equalsIgnoreCase(nic.networkSecurityGroupId())) {
                return Mono.empty();
            }
            return ((NetworkInterface.Update)nic.update()).withoutNetworkSecurityGroup().applyAsync();
        })).then(this.deleteInnerAsync(resourceGroupName, name)).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler());
    }

    public NetworkSecurityGroupImpl define(String name) {
        return this.wrapModel(name);
    }

    protected NetworkSecurityGroupImpl wrapModel(String name) {
        NetworkSecurityGroupInner inner = new NetworkSecurityGroupInner();
        return new NetworkSecurityGroupImpl(name, inner, (NetworkManager)this.manager());
    }

    protected NetworkSecurityGroupImpl wrapModel(NetworkSecurityGroupInner inner) {
        if (inner == null) {
            return null;
        }
        return new NetworkSecurityGroupImpl(inner.name(), inner, (NetworkManager)this.manager());
    }

    @Override
    public NetworkSecurityGroup getByResourceGroup(String resourceGroupName, String name, Context context) {
        return (NetworkSecurityGroup)this.getByResourceGroupAsync(resourceGroupName, name).contextWrite(c -> c.putAll(FluxUtil.toReactorContext((Context)context).readOnly())).block();
    }
}

