/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.RouteMapProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteMapRule;
import java.io.IOException;
import java.util.List;

public final class RouteMapInner
extends SubResource {
    private RouteMapProperties innerProperties;
    private String name;
    private String etag;
    private String type;

    private RouteMapProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public RouteMapInner withId(String id) {
        super.withId(id);
        return this;
    }

    public List<String> associatedInboundConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedInboundConnections();
    }

    public RouteMapInner withAssociatedInboundConnections(List<String> associatedInboundConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteMapProperties();
        }
        this.innerProperties().withAssociatedInboundConnections(associatedInboundConnections);
        return this;
    }

    public List<String> associatedOutboundConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedOutboundConnections();
    }

    public RouteMapInner withAssociatedOutboundConnections(List<String> associatedOutboundConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteMapProperties();
        }
        this.innerProperties().withAssociatedOutboundConnections(associatedOutboundConnections);
        return this;
    }

    public List<RouteMapRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    public RouteMapInner withRules(List<RouteMapRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteMapProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RouteMapInner fromJson(JsonReader jsonReader) throws IOException {
        return (RouteMapInner)((Object)jsonReader.readObject(reader -> {
            RouteMapInner deserializedRouteMapInner = new RouteMapInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRouteMapInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRouteMapInner.innerProperties = RouteMapProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRouteMapInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedRouteMapInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRouteMapInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteMapInner;
        }));
    }
}

