/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.BastionHostIpConfiguration;
import com.azure.resourcemanager.network.models.BastionHostPropertiesFormatNetworkAcls;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class BastionHostPropertiesFormat
implements JsonSerializable<BastionHostPropertiesFormat> {
    private List<BastionHostIpConfiguration> ipConfigurations;
    private String dnsName;
    private SubResource virtualNetwork;
    private BastionHostPropertiesFormatNetworkAcls networkAcls;
    private ProvisioningState provisioningState;
    private Integer scaleUnits;
    private Boolean disableCopyPaste;
    private Boolean enableFileCopy;
    private Boolean enableIpConnect;
    private Boolean enableShareableLink;
    private Boolean enableTunneling;
    private Boolean enableKerberos;
    private Boolean enableSessionRecording;
    private Boolean enablePrivateOnlyBastion;

    public List<BastionHostIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public BastionHostPropertiesFormat withIpConfigurations(List<BastionHostIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public BastionHostPropertiesFormat withDnsName(String dnsName) {
        this.dnsName = dnsName;
        return this;
    }

    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    public BastionHostPropertiesFormat withVirtualNetwork(SubResource virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public BastionHostPropertiesFormatNetworkAcls networkAcls() {
        return this.networkAcls;
    }

    public BastionHostPropertiesFormat withNetworkAcls(BastionHostPropertiesFormatNetworkAcls networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer scaleUnits() {
        return this.scaleUnits;
    }

    public BastionHostPropertiesFormat withScaleUnits(Integer scaleUnits) {
        this.scaleUnits = scaleUnits;
        return this;
    }

    public Boolean disableCopyPaste() {
        return this.disableCopyPaste;
    }

    public BastionHostPropertiesFormat withDisableCopyPaste(Boolean disableCopyPaste) {
        this.disableCopyPaste = disableCopyPaste;
        return this;
    }

    public Boolean enableFileCopy() {
        return this.enableFileCopy;
    }

    public BastionHostPropertiesFormat withEnableFileCopy(Boolean enableFileCopy) {
        this.enableFileCopy = enableFileCopy;
        return this;
    }

    public Boolean enableIpConnect() {
        return this.enableIpConnect;
    }

    public BastionHostPropertiesFormat withEnableIpConnect(Boolean enableIpConnect) {
        this.enableIpConnect = enableIpConnect;
        return this;
    }

    public Boolean enableShareableLink() {
        return this.enableShareableLink;
    }

    public BastionHostPropertiesFormat withEnableShareableLink(Boolean enableShareableLink) {
        this.enableShareableLink = enableShareableLink;
        return this;
    }

    public Boolean enableTunneling() {
        return this.enableTunneling;
    }

    public BastionHostPropertiesFormat withEnableTunneling(Boolean enableTunneling) {
        this.enableTunneling = enableTunneling;
        return this;
    }

    public Boolean enableKerberos() {
        return this.enableKerberos;
    }

    public BastionHostPropertiesFormat withEnableKerberos(Boolean enableKerberos) {
        this.enableKerberos = enableKerberos;
        return this;
    }

    public Boolean enableSessionRecording() {
        return this.enableSessionRecording;
    }

    public BastionHostPropertiesFormat withEnableSessionRecording(Boolean enableSessionRecording) {
        this.enableSessionRecording = enableSessionRecording;
        return this;
    }

    public Boolean enablePrivateOnlyBastion() {
        return this.enablePrivateOnlyBastion;
    }

    public BastionHostPropertiesFormat withEnablePrivateOnlyBastion(Boolean enablePrivateOnlyBastion) {
        this.enablePrivateOnlyBastion = enablePrivateOnlyBastion;
        return this;
    }

    public void validate() {
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("dnsName", this.dnsName);
        jsonWriter.writeJsonField("virtualNetwork", (JsonSerializable)this.virtualNetwork);
        jsonWriter.writeJsonField("networkAcls", (JsonSerializable)this.networkAcls);
        jsonWriter.writeNumberField("scaleUnits", (Number)this.scaleUnits);
        jsonWriter.writeBooleanField("disableCopyPaste", this.disableCopyPaste);
        jsonWriter.writeBooleanField("enableFileCopy", this.enableFileCopy);
        jsonWriter.writeBooleanField("enableIpConnect", this.enableIpConnect);
        jsonWriter.writeBooleanField("enableShareableLink", this.enableShareableLink);
        jsonWriter.writeBooleanField("enableTunneling", this.enableTunneling);
        jsonWriter.writeBooleanField("enableKerberos", this.enableKerberos);
        jsonWriter.writeBooleanField("enableSessionRecording", this.enableSessionRecording);
        jsonWriter.writeBooleanField("enablePrivateOnlyBastion", this.enablePrivateOnlyBastion);
        return jsonWriter.writeEndObject();
    }

    public static BastionHostPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (BastionHostPropertiesFormat)jsonReader.readObject(reader -> {
            BastionHostPropertiesFormat deserializedBastionHostPropertiesFormat = new BastionHostPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedBastionHostPropertiesFormat.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> BastionHostIpConfiguration.fromJson(reader1));
                    continue;
                }
                if ("dnsName".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.dnsName = reader.getString();
                    continue;
                }
                if ("virtualNetwork".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.virtualNetwork = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("networkAcls".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.networkAcls = BastionHostPropertiesFormatNetworkAcls.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("scaleUnits".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.scaleUnits = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("disableCopyPaste".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.disableCopyPaste = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableFileCopy".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.enableFileCopy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableIpConnect".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.enableIpConnect = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableShareableLink".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.enableShareableLink = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableTunneling".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.enableTunneling = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableKerberos".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.enableKerberos = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableSessionRecording".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.enableSessionRecording = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enablePrivateOnlyBastion".equals(fieldName)) {
                    deserializedBastionHostPropertiesFormat.enablePrivateOnlyBastion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBastionHostPropertiesFormat;
        });
    }
}

