// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Query Request Options.
 */
@Fluent
public final class QueryRequestOptions implements JsonSerializable<QueryRequestOptions> {
    /*
     * When present, the value can be passed to a subsequent query call (together with the same query and scopes used in
     * the current request) to retrieve the next page of data.
     */
    private String skipToken;

    /**
     * Creates an instance of QueryRequestOptions class.
     */
    public QueryRequestOptions() {
    }

    /**
     * Get the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     * 
     * @return the skipToken value.
     */
    public String skipToken() {
        return this.skipToken;
    }

    /**
     * Set the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     * 
     * @param skipToken the skipToken value to set.
     * @return the QueryRequestOptions object itself.
     */
    public QueryRequestOptions withSkipToken(String skipToken) {
        this.skipToken = skipToken;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("skipToken", this.skipToken);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryRequestOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryRequestOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryRequestOptions.
     */
    public static QueryRequestOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryRequestOptions deserializedQueryRequestOptions = new QueryRequestOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("skipToken".equals(fieldName)) {
                    deserializedQueryRequestOptions.skipToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryRequestOptions;
        });
    }
}
