// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration of the protocol.
 */
@Fluent
public final class ProtocolConfiguration implements JsonSerializable<ProtocolConfiguration> {
    /*
     * HTTP configuration of the connectivity check.
     */
    private HttpConfiguration httpConfiguration;

    /**
     * Creates an instance of ProtocolConfiguration class.
     */
    public ProtocolConfiguration() {
    }

    /**
     * Get the httpConfiguration property: HTTP configuration of the connectivity check.
     * 
     * @return the httpConfiguration value.
     */
    public HttpConfiguration httpConfiguration() {
        return this.httpConfiguration;
    }

    /**
     * Set the httpConfiguration property: HTTP configuration of the connectivity check.
     * 
     * @param httpConfiguration the httpConfiguration value to set.
     * @return the ProtocolConfiguration object itself.
     */
    public ProtocolConfiguration withHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (httpConfiguration() != null) {
            httpConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("HTTPConfiguration", this.httpConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProtocolConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProtocolConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProtocolConfiguration.
     */
    public static ProtocolConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProtocolConfiguration deserializedProtocolConfiguration = new ProtocolConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("HTTPConfiguration".equals(fieldName)) {
                    deserializedProtocolConfiguration.httpConfiguration = HttpConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProtocolConfiguration;
        });
    }
}
