// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters to get network configuration diagnostic.
 */
@Fluent
public final class NetworkConfigurationDiagnosticParameters
    implements JsonSerializable<NetworkConfigurationDiagnosticParameters> {
    /*
     * The ID of the target resource to perform network configuration diagnostic. Valid options are VM,
     * NetworkInterface, VMSS/NetworkInterface and Application Gateway.
     */
    private String targetResourceId;

    /*
     * Verbosity level.
     */
    private VerbosityLevel verbosityLevel;

    /*
     * List of network configuration diagnostic profiles.
     */
    private List<NetworkConfigurationDiagnosticProfile> profiles;

    /**
     * Creates an instance of NetworkConfigurationDiagnosticParameters class.
     */
    public NetworkConfigurationDiagnosticParameters() {
    }

    /**
     * Get the targetResourceId property: The ID of the target resource to perform network configuration diagnostic.
     * Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application Gateway.
     * 
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Set the targetResourceId property: The ID of the target resource to perform network configuration diagnostic.
     * Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application Gateway.
     * 
     * @param targetResourceId the targetResourceId value to set.
     * @return the NetworkConfigurationDiagnosticParameters object itself.
     */
    public NetworkConfigurationDiagnosticParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    /**
     * Get the verbosityLevel property: Verbosity level.
     * 
     * @return the verbosityLevel value.
     */
    public VerbosityLevel verbosityLevel() {
        return this.verbosityLevel;
    }

    /**
     * Set the verbosityLevel property: Verbosity level.
     * 
     * @param verbosityLevel the verbosityLevel value to set.
     * @return the NetworkConfigurationDiagnosticParameters object itself.
     */
    public NetworkConfigurationDiagnosticParameters withVerbosityLevel(VerbosityLevel verbosityLevel) {
        this.verbosityLevel = verbosityLevel;
        return this;
    }

    /**
     * Get the profiles property: List of network configuration diagnostic profiles.
     * 
     * @return the profiles value.
     */
    public List<NetworkConfigurationDiagnosticProfile> profiles() {
        return this.profiles;
    }

    /**
     * Set the profiles property: List of network configuration diagnostic profiles.
     * 
     * @param profiles the profiles value to set.
     * @return the NetworkConfigurationDiagnosticParameters object itself.
     */
    public NetworkConfigurationDiagnosticParameters withProfiles(List<NetworkConfigurationDiagnosticProfile> profiles) {
        this.profiles = profiles;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property targetResourceId in model NetworkConfigurationDiagnosticParameters"));
        }
        if (profiles() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property profiles in model NetworkConfigurationDiagnosticParameters"));
        } else {
            profiles().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(NetworkConfigurationDiagnosticParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeArrayField("profiles", this.profiles, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("verbosityLevel",
            this.verbosityLevel == null ? null : this.verbosityLevel.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkConfigurationDiagnosticParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkConfigurationDiagnosticParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NetworkConfigurationDiagnosticParameters.
     */
    public static NetworkConfigurationDiagnosticParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkConfigurationDiagnosticParameters deserializedNetworkConfigurationDiagnosticParameters
                = new NetworkConfigurationDiagnosticParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetResourceId".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticParameters.targetResourceId = reader.getString();
                } else if ("profiles".equals(fieldName)) {
                    List<NetworkConfigurationDiagnosticProfile> profiles
                        = reader.readArray(reader1 -> NetworkConfigurationDiagnosticProfile.fromJson(reader1));
                    deserializedNetworkConfigurationDiagnosticParameters.profiles = profiles;
                } else if ("verbosityLevel".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticParameters.verbosityLevel
                        = VerbosityLevel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkConfigurationDiagnosticParameters;
        });
    }
}
