// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Intent information.
 */
@Fluent
public final class IntentContent implements JsonSerializable<IntentContent> {
    /*
     * The description property.
     */
    private String description;

    /*
     * Source resource id of the intent.
     */
    private String sourceResourceId;

    /*
     * Destination resource id of the intent.
     */
    private String destinationResourceId;

    /*
     * IP traffic information.
     */
    private IpTraffic ipTraffic;

    /**
     * Creates an instance of IntentContent class.
     */
    public IntentContent() {
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the IntentContent object itself.
     */
    public IntentContent withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the sourceResourceId property: Source resource id of the intent.
     * 
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    /**
     * Set the sourceResourceId property: Source resource id of the intent.
     * 
     * @param sourceResourceId the sourceResourceId value to set.
     * @return the IntentContent object itself.
     */
    public IntentContent withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    /**
     * Get the destinationResourceId property: Destination resource id of the intent.
     * 
     * @return the destinationResourceId value.
     */
    public String destinationResourceId() {
        return this.destinationResourceId;
    }

    /**
     * Set the destinationResourceId property: Destination resource id of the intent.
     * 
     * @param destinationResourceId the destinationResourceId value to set.
     * @return the IntentContent object itself.
     */
    public IntentContent withDestinationResourceId(String destinationResourceId) {
        this.destinationResourceId = destinationResourceId;
        return this;
    }

    /**
     * Get the ipTraffic property: IP traffic information.
     * 
     * @return the ipTraffic value.
     */
    public IpTraffic ipTraffic() {
        return this.ipTraffic;
    }

    /**
     * Set the ipTraffic property: IP traffic information.
     * 
     * @param ipTraffic the ipTraffic value to set.
     * @return the IntentContent object itself.
     */
    public IntentContent withIpTraffic(IpTraffic ipTraffic) {
        this.ipTraffic = ipTraffic;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property sourceResourceId in model IntentContent"));
        }
        if (destinationResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destinationResourceId in model IntentContent"));
        }
        if (ipTraffic() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property ipTraffic in model IntentContent"));
        } else {
            ipTraffic().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IntentContent.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId);
        jsonWriter.writeStringField("destinationResourceId", this.destinationResourceId);
        jsonWriter.writeJsonField("ipTraffic", this.ipTraffic);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IntentContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IntentContent if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IntentContent.
     */
    public static IntentContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IntentContent deserializedIntentContent = new IntentContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceResourceId".equals(fieldName)) {
                    deserializedIntentContent.sourceResourceId = reader.getString();
                } else if ("destinationResourceId".equals(fieldName)) {
                    deserializedIntentContent.destinationResourceId = reader.getString();
                } else if ("ipTraffic".equals(fieldName)) {
                    deserializedIntentContent.ipTraffic = IpTraffic.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    deserializedIntentContent.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIntentContent;
        });
    }
}
