// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Reference to an express route circuit.
 */
@Fluent
public final class ExpressRouteCircuitReference implements JsonSerializable<ExpressRouteCircuitReference> {
    /*
     * Corresponding Express Route Circuit Id.
     */
    private String id;

    /**
     * Creates an instance of ExpressRouteCircuitReference class.
     */
    public ExpressRouteCircuitReference() {
    }

    /**
     * Get the id property: Corresponding Express Route Circuit Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Corresponding Express Route Circuit Id.
     * 
     * @param id the id value to set.
     * @return the ExpressRouteCircuitReference object itself.
     */
    public ExpressRouteCircuitReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCircuitReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCircuitReference if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCircuitReference.
     */
    public static ExpressRouteCircuitReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCircuitReference deserializedExpressRouteCircuitReference = new ExpressRouteCircuitReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedExpressRouteCircuitReference.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCircuitReference;
        });
    }
}
