// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of identity that created the resource.
 */
public final class CreatedByType extends ExpandableStringEnum<CreatedByType> {
    /**
     * Static value User for CreatedByType.
     */
    public static final CreatedByType USER = fromString("User");

    /**
     * Static value Application for CreatedByType.
     */
    public static final CreatedByType APPLICATION = fromString("Application");

    /**
     * Static value ManagedIdentity for CreatedByType.
     */
    public static final CreatedByType MANAGED_IDENTITY = fromString("ManagedIdentity");

    /**
     * Static value Key for CreatedByType.
     */
    public static final CreatedByType KEY = fromString("Key");

    /**
     * Creates a new instance of CreatedByType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CreatedByType() {
    }

    /**
     * Creates or finds a CreatedByType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding CreatedByType.
     */
    public static CreatedByType fromString(String name) {
        return fromString(name, CreatedByType.class);
    }

    /**
     * Gets known CreatedByType values.
     * 
     * @return known CreatedByType values.
     */
    public static Collection<CreatedByType> values() {
        return values(CreatedByType.class);
    }
}
