// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Prefix properties required to perform validation using openssl signature.
 */
@Fluent
public final class AdvertisedPublicPrefixProperties implements JsonSerializable<AdvertisedPublicPrefixProperties> {
    /*
     * Advertised Public Prefix.
     */
    private String prefix;

    /*
     * Validation string that contains circuit peering info.
     */
    private String validationId;

    /*
     * Signed string generated by encrypting validationId with a private key.
     */
    private String signature;

    /*
     * Advertised Public Prefix State that denotes if the prefix is validated or not.
     */
    private AdvertisedPublicPrefixPropertiesValidationState validationState;

    /**
     * Creates an instance of AdvertisedPublicPrefixProperties class.
     */
    public AdvertisedPublicPrefixProperties() {
    }

    /**
     * Get the prefix property: Advertised Public Prefix.
     * 
     * @return the prefix value.
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: Advertised Public Prefix.
     * 
     * @param prefix the prefix value to set.
     * @return the AdvertisedPublicPrefixProperties object itself.
     */
    public AdvertisedPublicPrefixProperties withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the validationId property: Validation string that contains circuit peering info.
     * 
     * @return the validationId value.
     */
    public String validationId() {
        return this.validationId;
    }

    /**
     * Set the validationId property: Validation string that contains circuit peering info.
     * 
     * @param validationId the validationId value to set.
     * @return the AdvertisedPublicPrefixProperties object itself.
     */
    public AdvertisedPublicPrefixProperties withValidationId(String validationId) {
        this.validationId = validationId;
        return this;
    }

    /**
     * Get the signature property: Signed string generated by encrypting validationId with a private key.
     * 
     * @return the signature value.
     */
    public String signature() {
        return this.signature;
    }

    /**
     * Set the signature property: Signed string generated by encrypting validationId with a private key.
     * 
     * @param signature the signature value to set.
     * @return the AdvertisedPublicPrefixProperties object itself.
     */
    public AdvertisedPublicPrefixProperties withSignature(String signature) {
        this.signature = signature;
        return this;
    }

    /**
     * Get the validationState property: Advertised Public Prefix State that denotes if the prefix is validated or not.
     * 
     * @return the validationState value.
     */
    public AdvertisedPublicPrefixPropertiesValidationState validationState() {
        return this.validationState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("prefix", this.prefix);
        jsonWriter.writeStringField("validationId", this.validationId);
        jsonWriter.writeStringField("signature", this.signature);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdvertisedPublicPrefixProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdvertisedPublicPrefixProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AdvertisedPublicPrefixProperties.
     */
    public static AdvertisedPublicPrefixProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdvertisedPublicPrefixProperties deserializedAdvertisedPublicPrefixProperties
                = new AdvertisedPublicPrefixProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("prefix".equals(fieldName)) {
                    deserializedAdvertisedPublicPrefixProperties.prefix = reader.getString();
                } else if ("validationId".equals(fieldName)) {
                    deserializedAdvertisedPublicPrefixProperties.validationId = reader.getString();
                } else if ("signature".equals(fieldName)) {
                    deserializedAdvertisedPublicPrefixProperties.signature = reader.getString();
                } else if ("validationState".equals(fieldName)) {
                    deserializedAdvertisedPublicPrefixProperties.validationState
                        = AdvertisedPublicPrefixPropertiesValidationState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAdvertisedPublicPrefixProperties;
        });
    }
}
