// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.VpnClientConnectionHealthDetail;
import java.io.IOException;
import java.util.List;

/**
 * List of virtual network gateway vpn client connection health.
 */
@Fluent
public final class VpnClientConnectionHealthDetailListResultInner
    implements JsonSerializable<VpnClientConnectionHealthDetailListResultInner> {
    /*
     * List of vpn client connection health.
     */
    private List<VpnClientConnectionHealthDetail> value;

    /**
     * Creates an instance of VpnClientConnectionHealthDetailListResultInner class.
     */
    public VpnClientConnectionHealthDetailListResultInner() {
    }

    /**
     * Get the value property: List of vpn client connection health.
     * 
     * @return the value value.
     */
    public List<VpnClientConnectionHealthDetail> value() {
        return this.value;
    }

    /**
     * Set the value property: List of vpn client connection health.
     * 
     * @param value the value value to set.
     * @return the VpnClientConnectionHealthDetailListResultInner object itself.
     */
    public VpnClientConnectionHealthDetailListResultInner withValue(List<VpnClientConnectionHealthDetail> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnClientConnectionHealthDetailListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnClientConnectionHealthDetailListResultInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnClientConnectionHealthDetailListResultInner.
     */
    public static VpnClientConnectionHealthDetailListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnClientConnectionHealthDetailListResultInner deserializedVpnClientConnectionHealthDetailListResultInner
                = new VpnClientConnectionHealthDetailListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VpnClientConnectionHealthDetail> value
                        = reader.readArray(reader1 -> VpnClientConnectionHealthDetail.fromJson(reader1));
                    deserializedVpnClientConnectionHealthDetailListResultInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnClientConnectionHealthDetailListResultInner;
        });
    }
}
