// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;

/**
 * The network security perimeter profile resource.
 */
@Immutable
public final class NspProfileInner extends SecurityPerimeterProxyResource {
    /*
     * Properties of the network security perimeter profile
     */
    private NspProfileProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SecurityPerimeterSystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NspProfileInner class.
     */
    public NspProfileInner() {
    }

    /**
     * Get the innerProperties property: Properties of the network security perimeter profile.
     * 
     * @return the innerProperties value.
     */
    private NspProfileProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the accessRulesVersion property: Version number that increases with every update to access rules within the
     * profile.
     * 
     * @return the accessRulesVersion value.
     */
    public String accessRulesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().accessRulesVersion();
    }

    /**
     * Get the diagnosticSettingsVersion property: Version number that increases with every update to diagnostic
     * settings within the profile.
     * 
     * @return the diagnosticSettingsVersion value.
     */
    public String diagnosticSettingsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().diagnosticSettingsVersion();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (systemData() != null) {
            systemData().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspProfileInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspProfileInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NspProfileInner.
     */
    public static NspProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspProfileInner deserializedNspProfileInner = new NspProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNspProfileInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNspProfileInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNspProfileInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedNspProfileInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedNspProfileInner.innerProperties = NspProfileProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspProfileInner;
        });
    }
}
