// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NspLinkProvisioningState;
import com.azure.resourcemanager.network.models.NspLinkStatus;
import java.io.IOException;
import java.util.List;

/**
 * Properties of NSP LinkReference resource.
 */
@Fluent
public final class NspLinkReferenceProperties implements JsonSerializable<NspLinkReferenceProperties> {
    /*
     * The provisioning state of the NSP LinkReference resource.
     */
    private NspLinkProvisioningState provisioningState;

    /*
     * Perimeter ARM Id for the remote NSP with which the link is created.
     */
    private String remotePerimeterResourceId;

    /*
     * Remote NSP Guid with which the link is created.
     */
    private String remotePerimeterGuid;

    /*
     * Remote NSP location with which the link gets created.
     */
    private String remotePerimeterLocation;

    /*
     * Local Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles.
     */
    private List<String> localInboundProfiles;

    /*
     * Local Outbound profile names from which Outbound is allowed. In current version, it is readonly property and it's
     * value is set to ['*'] to allow outbound from all profiles. In later version, user will be able to modify it.
     */
    private List<String> localOutboundProfiles;

    /*
     * Remote Inbound profile names to which Inbound is allowed. ['*'] value implies inbound is allowed to all profiles
     * at remote perimeter. This property can only be updated from corresponding link resource present in remote
     * perimeter.
     */
    private List<String> remoteInboundProfiles;

    /*
     * Remote Outbound profile names from which Outbound is allowed. ['*'] value implies outbound is allowed from all
     * profiles at remote perimeter. This property can only be updated from corresponding link resource present in
     * remote perimeter.
     */
    private List<String> remoteOutboundProfiles;

    /*
     * A message sent by the remote NSP link admin for connection request. In case of Auto-approved flow, it is default
     * to 'Auto Approved'.
     */
    private String description;

    /*
     * The NSP linkReference state. It cannot be changed if link is created in auto-approval mode.
     */
    private NspLinkStatus status;

    /**
     * Creates an instance of NspLinkReferenceProperties class.
     */
    public NspLinkReferenceProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the NSP LinkReference resource.
     * 
     * @return the provisioningState value.
     */
    public NspLinkProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the remotePerimeterResourceId property: Perimeter ARM Id for the remote NSP with which the link is created.
     * 
     * @return the remotePerimeterResourceId value.
     */
    public String remotePerimeterResourceId() {
        return this.remotePerimeterResourceId;
    }

    /**
     * Get the remotePerimeterGuid property: Remote NSP Guid with which the link is created.
     * 
     * @return the remotePerimeterGuid value.
     */
    public String remotePerimeterGuid() {
        return this.remotePerimeterGuid;
    }

    /**
     * Get the remotePerimeterLocation property: Remote NSP location with which the link gets created.
     * 
     * @return the remotePerimeterLocation value.
     */
    public String remotePerimeterLocation() {
        return this.remotePerimeterLocation;
    }

    /**
     * Get the localInboundProfiles property: Local Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles.
     * 
     * @return the localInboundProfiles value.
     */
    public List<String> localInboundProfiles() {
        return this.localInboundProfiles;
    }

    /**
     * Set the localInboundProfiles property: Local Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles.
     * 
     * @param localInboundProfiles the localInboundProfiles value to set.
     * @return the NspLinkReferenceProperties object itself.
     */
    public NspLinkReferenceProperties withLocalInboundProfiles(List<String> localInboundProfiles) {
        this.localInboundProfiles = localInboundProfiles;
        return this;
    }

    /**
     * Get the localOutboundProfiles property: Local Outbound profile names from which Outbound is allowed. In current
     * version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later
     * version, user will be able to modify it.
     * 
     * @return the localOutboundProfiles value.
     */
    public List<String> localOutboundProfiles() {
        return this.localOutboundProfiles;
    }

    /**
     * Get the remoteInboundProfiles property: Remote Inbound profile names to which Inbound is allowed. ['*'] value
     * implies inbound is allowed to all profiles at remote perimeter. This property can only be updated from
     * corresponding link resource present in remote perimeter.
     * 
     * @return the remoteInboundProfiles value.
     */
    public List<String> remoteInboundProfiles() {
        return this.remoteInboundProfiles;
    }

    /**
     * Get the remoteOutboundProfiles property: Remote Outbound profile names from which Outbound is allowed. ['*']
     * value implies outbound is allowed from all profiles at remote perimeter. This property can only be updated from
     * corresponding link resource present in remote perimeter.
     * 
     * @return the remoteOutboundProfiles value.
     */
    public List<String> remoteOutboundProfiles() {
        return this.remoteOutboundProfiles;
    }

    /**
     * Get the description property: A message sent by the remote NSP link admin for connection request. In case of
     * Auto-approved flow, it is default to 'Auto Approved'.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the status property: The NSP linkReference state. It cannot be changed if link is created in auto-approval
     * mode.
     * 
     * @return the status value.
     */
    public NspLinkStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The NSP linkReference state. It cannot be changed if link is created in auto-approval
     * mode.
     * 
     * @param status the status value to set.
     * @return the NspLinkReferenceProperties object itself.
     */
    public NspLinkReferenceProperties withStatus(NspLinkStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("localInboundProfiles", this.localInboundProfiles,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspLinkReferenceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspLinkReferenceProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspLinkReferenceProperties.
     */
    public static NspLinkReferenceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspLinkReferenceProperties deserializedNspLinkReferenceProperties = new NspLinkReferenceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.provisioningState
                        = NspLinkProvisioningState.fromString(reader.getString());
                } else if ("remotePerimeterResourceId".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.remotePerimeterResourceId = reader.getString();
                } else if ("remotePerimeterGuid".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.remotePerimeterGuid = reader.getString();
                } else if ("remotePerimeterLocation".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.remotePerimeterLocation = reader.getString();
                } else if ("localInboundProfiles".equals(fieldName)) {
                    List<String> localInboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspLinkReferenceProperties.localInboundProfiles = localInboundProfiles;
                } else if ("localOutboundProfiles".equals(fieldName)) {
                    List<String> localOutboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspLinkReferenceProperties.localOutboundProfiles = localOutboundProfiles;
                } else if ("remoteInboundProfiles".equals(fieldName)) {
                    List<String> remoteInboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspLinkReferenceProperties.remoteInboundProfiles = remoteInboundProfiles;
                } else if ("remoteOutboundProfiles".equals(fieldName)) {
                    List<String> remoteOutboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspLinkReferenceProperties.remoteOutboundProfiles = remoteOutboundProfiles;
                } else if ("description".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.description = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.status = NspLinkStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspLinkReferenceProperties;
        });
    }
}
