// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ResiliencyRecommendationComponents;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Gateway Resiliency Information.
 */
@Fluent
public final class GatewayResiliencyInformationInner implements JsonSerializable<GatewayResiliencyInformationInner> {
    /*
     * Current Resiliency Score for the gateway
     */
    private String overallScore;

    /*
     * Update in the Resiliency Score for the gateway from the last computed score
     */
    private String scoreChange;

    /*
     * Minimum increase expected in the score if the at least one of the recommendations is applied for the gateway
     */
    private String minScoreFromRecommendations;

    /*
     * Maximum increase expected in the score if all of the recommendations are applied for the gateway
     */
    private String maxScoreFromRecommendations;

    /*
     * Timestamp denoting the last time when the resiliency score was computed for the gateway
     */
    private OffsetDateTime lastComputedTime;

    /*
     * Timestamp denoting the next eligible time to re-compute the resiliency score for the gateway
     */
    private OffsetDateTime nextEligibleComputeTime;

    /*
     * List of Resiliency based Recommendation Components for the gateway
     */
    private List<ResiliencyRecommendationComponents> components;

    /**
     * Creates an instance of GatewayResiliencyInformationInner class.
     */
    public GatewayResiliencyInformationInner() {
    }

    /**
     * Get the overallScore property: Current Resiliency Score for the gateway.
     * 
     * @return the overallScore value.
     */
    public String overallScore() {
        return this.overallScore;
    }

    /**
     * Set the overallScore property: Current Resiliency Score for the gateway.
     * 
     * @param overallScore the overallScore value to set.
     * @return the GatewayResiliencyInformationInner object itself.
     */
    public GatewayResiliencyInformationInner withOverallScore(String overallScore) {
        this.overallScore = overallScore;
        return this;
    }

    /**
     * Get the scoreChange property: Update in the Resiliency Score for the gateway from the last computed score.
     * 
     * @return the scoreChange value.
     */
    public String scoreChange() {
        return this.scoreChange;
    }

    /**
     * Set the scoreChange property: Update in the Resiliency Score for the gateway from the last computed score.
     * 
     * @param scoreChange the scoreChange value to set.
     * @return the GatewayResiliencyInformationInner object itself.
     */
    public GatewayResiliencyInformationInner withScoreChange(String scoreChange) {
        this.scoreChange = scoreChange;
        return this;
    }

    /**
     * Get the minScoreFromRecommendations property: Minimum increase expected in the score if the at least one of the
     * recommendations is applied for the gateway.
     * 
     * @return the minScoreFromRecommendations value.
     */
    public String minScoreFromRecommendations() {
        return this.minScoreFromRecommendations;
    }

    /**
     * Set the minScoreFromRecommendations property: Minimum increase expected in the score if the at least one of the
     * recommendations is applied for the gateway.
     * 
     * @param minScoreFromRecommendations the minScoreFromRecommendations value to set.
     * @return the GatewayResiliencyInformationInner object itself.
     */
    public GatewayResiliencyInformationInner withMinScoreFromRecommendations(String minScoreFromRecommendations) {
        this.minScoreFromRecommendations = minScoreFromRecommendations;
        return this;
    }

    /**
     * Get the maxScoreFromRecommendations property: Maximum increase expected in the score if all of the
     * recommendations are applied for the gateway.
     * 
     * @return the maxScoreFromRecommendations value.
     */
    public String maxScoreFromRecommendations() {
        return this.maxScoreFromRecommendations;
    }

    /**
     * Set the maxScoreFromRecommendations property: Maximum increase expected in the score if all of the
     * recommendations are applied for the gateway.
     * 
     * @param maxScoreFromRecommendations the maxScoreFromRecommendations value to set.
     * @return the GatewayResiliencyInformationInner object itself.
     */
    public GatewayResiliencyInformationInner withMaxScoreFromRecommendations(String maxScoreFromRecommendations) {
        this.maxScoreFromRecommendations = maxScoreFromRecommendations;
        return this;
    }

    /**
     * Get the lastComputedTime property: Timestamp denoting the last time when the resiliency score was computed for
     * the gateway.
     * 
     * @return the lastComputedTime value.
     */
    public OffsetDateTime lastComputedTime() {
        return this.lastComputedTime;
    }

    /**
     * Set the lastComputedTime property: Timestamp denoting the last time when the resiliency score was computed for
     * the gateway.
     * 
     * @param lastComputedTime the lastComputedTime value to set.
     * @return the GatewayResiliencyInformationInner object itself.
     */
    public GatewayResiliencyInformationInner withLastComputedTime(OffsetDateTime lastComputedTime) {
        this.lastComputedTime = lastComputedTime;
        return this;
    }

    /**
     * Get the nextEligibleComputeTime property: Timestamp denoting the next eligible time to re-compute the resiliency
     * score for the gateway.
     * 
     * @return the nextEligibleComputeTime value.
     */
    public OffsetDateTime nextEligibleComputeTime() {
        return this.nextEligibleComputeTime;
    }

    /**
     * Set the nextEligibleComputeTime property: Timestamp denoting the next eligible time to re-compute the resiliency
     * score for the gateway.
     * 
     * @param nextEligibleComputeTime the nextEligibleComputeTime value to set.
     * @return the GatewayResiliencyInformationInner object itself.
     */
    public GatewayResiliencyInformationInner withNextEligibleComputeTime(OffsetDateTime nextEligibleComputeTime) {
        this.nextEligibleComputeTime = nextEligibleComputeTime;
        return this;
    }

    /**
     * Get the components property: List of Resiliency based Recommendation Components for the gateway.
     * 
     * @return the components value.
     */
    public List<ResiliencyRecommendationComponents> components() {
        return this.components;
    }

    /**
     * Set the components property: List of Resiliency based Recommendation Components for the gateway.
     * 
     * @param components the components value to set.
     * @return the GatewayResiliencyInformationInner object itself.
     */
    public GatewayResiliencyInformationInner withComponents(List<ResiliencyRecommendationComponents> components) {
        this.components = components;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (components() != null) {
            components().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("overallScore", this.overallScore);
        jsonWriter.writeStringField("scoreChange", this.scoreChange);
        jsonWriter.writeStringField("minScoreFromRecommendations", this.minScoreFromRecommendations);
        jsonWriter.writeStringField("maxScoreFromRecommendations", this.maxScoreFromRecommendations);
        jsonWriter.writeStringField("lastComputedTime",
            this.lastComputedTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastComputedTime));
        jsonWriter.writeStringField("nextEligibleComputeTime",
            this.nextEligibleComputeTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextEligibleComputeTime));
        jsonWriter.writeArrayField("components", this.components, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayResiliencyInformationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayResiliencyInformationInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayResiliencyInformationInner.
     */
    public static GatewayResiliencyInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayResiliencyInformationInner deserializedGatewayResiliencyInformationInner
                = new GatewayResiliencyInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("overallScore".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.overallScore = reader.getString();
                } else if ("scoreChange".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.scoreChange = reader.getString();
                } else if ("minScoreFromRecommendations".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.minScoreFromRecommendations = reader.getString();
                } else if ("maxScoreFromRecommendations".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.maxScoreFromRecommendations = reader.getString();
                } else if ("lastComputedTime".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.lastComputedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("nextEligibleComputeTime".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.nextEligibleComputeTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("components".equals(fieldName)) {
                    List<ResiliencyRecommendationComponents> components
                        = reader.readArray(reader1 -> ResiliencyRecommendationComponents.fromJson(reader1));
                    deserializedGatewayResiliencyInformationInner.components = components;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayResiliencyInformationInner;
        });
    }
}
