// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * List of ExpressRoute gateways.
 */
@Fluent
public final class ExpressRouteGatewayListInner implements JsonSerializable<ExpressRouteGatewayListInner> {
    /*
     * List of ExpressRoute gateways.
     */
    private List<ExpressRouteGatewayInner> value;

    /**
     * Creates an instance of ExpressRouteGatewayListInner class.
     */
    public ExpressRouteGatewayListInner() {
    }

    /**
     * Get the value property: List of ExpressRoute gateways.
     * 
     * @return the value value.
     */
    public List<ExpressRouteGatewayInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of ExpressRoute gateways.
     * 
     * @param value the value value to set.
     * @return the ExpressRouteGatewayListInner object itself.
     */
    public ExpressRouteGatewayListInner withValue(List<ExpressRouteGatewayInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteGatewayListInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteGatewayListInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteGatewayListInner.
     */
    public static ExpressRouteGatewayListInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteGatewayListInner deserializedExpressRouteGatewayListInner = new ExpressRouteGatewayListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ExpressRouteGatewayInner> value
                        = reader.readArray(reader1 -> ExpressRouteGatewayInner.fromJson(reader1));
                    deserializedExpressRouteGatewayListInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteGatewayListInner;
        });
    }
}
