// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.network.fluent.models.NspLoggingConfigurationInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * NetworkSecurityPerimeterLoggingConfigurationsClient.
 */
public interface NetworkSecurityPerimeterLoggingConfigurationsClient {
    /**
     * Gets the NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP logging configuration along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NspLoggingConfigurationInner>> getWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String loggingConfigurationName);

    /**
     * Gets the NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP logging configuration on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NspLoggingConfigurationInner> getAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String loggingConfigurationName);

    /**
     * Gets the NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP logging configuration along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NspLoggingConfigurationInner> getWithResponse(String resourceGroupName,
        String networkSecurityPerimeterName, String loggingConfigurationName, Context context);

    /**
     * Gets the NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP logging configuration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NspLoggingConfigurationInner get(String resourceGroupName, String networkSecurityPerimeterName,
        String loggingConfigurationName);

    /**
     * Creates or updates NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @param parameters Parameters that hold the NspLoggingConfiguration to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP logging configuration along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NspLoggingConfigurationInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String loggingConfigurationName, NspLoggingConfigurationInner parameters);

    /**
     * Creates or updates NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @param parameters Parameters that hold the NspLoggingConfiguration to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP logging configuration on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NspLoggingConfigurationInner> createOrUpdateAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String loggingConfigurationName, NspLoggingConfigurationInner parameters);

    /**
     * Creates or updates NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @param parameters Parameters that hold the NspLoggingConfiguration to be created/updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP logging configuration along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NspLoggingConfigurationInner> createOrUpdateWithResponse(String resourceGroupName,
        String networkSecurityPerimeterName, String loggingConfigurationName, NspLoggingConfigurationInner parameters,
        Context context);

    /**
     * Creates or updates NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @param parameters Parameters that hold the NspLoggingConfiguration to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP logging configuration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NspLoggingConfigurationInner createOrUpdate(String resourceGroupName, String networkSecurityPerimeterName,
        String loggingConfigurationName, NspLoggingConfigurationInner parameters);

    /**
     * Deletes an NSP Logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String loggingConfigurationName);

    /**
     * Deletes an NSP Logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String loggingConfigurationName);

    /**
     * Deletes an NSP Logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String networkSecurityPerimeterName,
        String loggingConfigurationName, Context context);

    /**
     * Deletes an NSP Logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param loggingConfigurationName The name of the NSP logging configuration. Accepts 'instance' as name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkSecurityPerimeterName, String loggingConfigurationName);

    /**
     * Lists the NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP logging configuration as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NspLoggingConfigurationInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName);

    /**
     * Lists the NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP logging configuration as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NspLoggingConfigurationInner> list(String resourceGroupName, String networkSecurityPerimeterName);

    /**
     * Lists the NSP logging configuration.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP logging configuration as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NspLoggingConfigurationInner> list(String resourceGroupName, String networkSecurityPerimeterName,
        Context context);
}
