/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitConnectionPropertiesFormat;
import com.azure.resourcemanager.network.models.CircuitConnectionStatus;
import com.azure.resourcemanager.network.models.Ipv6CircuitConnectionConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ExpressRouteCircuitConnectionInner
extends SubResource {
    private ExpressRouteCircuitConnectionPropertiesFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private ExpressRouteCircuitConnectionPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ExpressRouteCircuitConnectionInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ExpressRouteCircuitConnectionInner withId(String id) {
        super.withId(id);
        return this;
    }

    public SubResource expressRouteCircuitPeering() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteCircuitPeering();
    }

    public ExpressRouteCircuitConnectionInner withExpressRouteCircuitPeering(SubResource expressRouteCircuitPeering) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitConnectionPropertiesFormat();
        }
        this.innerProperties().withExpressRouteCircuitPeering(expressRouteCircuitPeering);
        return this;
    }

    public SubResource peerExpressRouteCircuitPeering() {
        return this.innerProperties() == null ? null : this.innerProperties().peerExpressRouteCircuitPeering();
    }

    public ExpressRouteCircuitConnectionInner withPeerExpressRouteCircuitPeering(SubResource peerExpressRouteCircuitPeering) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitConnectionPropertiesFormat();
        }
        this.innerProperties().withPeerExpressRouteCircuitPeering(peerExpressRouteCircuitPeering);
        return this;
    }

    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    public ExpressRouteCircuitConnectionInner withAddressPrefix(String addressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitConnectionPropertiesFormat();
        }
        this.innerProperties().withAddressPrefix(addressPrefix);
        return this;
    }

    public String authorizationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationKey();
    }

    public ExpressRouteCircuitConnectionInner withAuthorizationKey(String authorizationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitConnectionPropertiesFormat();
        }
        this.innerProperties().withAuthorizationKey(authorizationKey);
        return this;
    }

    public Ipv6CircuitConnectionConfig ipv6CircuitConnectionConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().ipv6CircuitConnectionConfig();
    }

    public ExpressRouteCircuitConnectionInner withIpv6CircuitConnectionConfig(Ipv6CircuitConnectionConfig ipv6CircuitConnectionConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitConnectionPropertiesFormat();
        }
        this.innerProperties().withIpv6CircuitConnectionConfig(ipv6CircuitConnectionConfig);
        return this;
    }

    public CircuitConnectionStatus circuitConnectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().circuitConnectionStatus();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCircuitConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteCircuitConnectionInner)((Object)jsonReader.readObject(reader -> {
            ExpressRouteCircuitConnectionInner deserializedExpressRouteCircuitConnectionInner = new ExpressRouteCircuitConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionInner.innerProperties = ExpressRouteCircuitConnectionPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCircuitConnectionInner;
        }));
    }
}

