/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.SecurityPerimeterResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;
import java.util.Map;

public final class TrackedResource
extends SecurityPerimeterResource {
    private Map<String, String> tags;
    private String location;
    private SecurityPerimeterSystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(TrackedResource.class);

    public Map<String, String> tags() {
        return this.tags;
    }

    public TrackedResource withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public TrackedResource withLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model TrackedResource"));
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static TrackedResource fromJson(JsonReader jsonReader) throws IOException {
        return (TrackedResource)((Object)jsonReader.readObject(reader -> {
            TrackedResource deserializedTrackedResource = new TrackedResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTrackedResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTrackedResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTrackedResource.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedTrackedResource.systemData = SecurityPerimeterSystemData.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTrackedResource.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedTrackedResource.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrackedResource;
        }));
    }
}

