/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NetworkIntentPolicyConfiguration;
import java.io.IOException;
import java.util.List;

public final class PrepareNetworkPoliciesRequest
implements JsonSerializable<PrepareNetworkPoliciesRequest> {
    private String serviceName;
    private List<NetworkIntentPolicyConfiguration> networkIntentPolicyConfigurations;

    public String serviceName() {
        return this.serviceName;
    }

    public PrepareNetworkPoliciesRequest withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public List<NetworkIntentPolicyConfiguration> networkIntentPolicyConfigurations() {
        return this.networkIntentPolicyConfigurations;
    }

    public PrepareNetworkPoliciesRequest withNetworkIntentPolicyConfigurations(List<NetworkIntentPolicyConfiguration> networkIntentPolicyConfigurations) {
        this.networkIntentPolicyConfigurations = networkIntentPolicyConfigurations;
        return this;
    }

    public void validate() {
        if (this.networkIntentPolicyConfigurations() != null) {
            this.networkIntentPolicyConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName);
        jsonWriter.writeArrayField("networkIntentPolicyConfigurations", this.networkIntentPolicyConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PrepareNetworkPoliciesRequest fromJson(JsonReader jsonReader) throws IOException {
        return (PrepareNetworkPoliciesRequest)jsonReader.readObject(reader -> {
            PrepareNetworkPoliciesRequest deserializedPrepareNetworkPoliciesRequest = new PrepareNetworkPoliciesRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceName".equals(fieldName)) {
                    deserializedPrepareNetworkPoliciesRequest.serviceName = reader.getString();
                    continue;
                }
                if ("networkIntentPolicyConfigurations".equals(fieldName)) {
                    List networkIntentPolicyConfigurations;
                    deserializedPrepareNetworkPoliciesRequest.networkIntentPolicyConfigurations = networkIntentPolicyConfigurations = reader.readArray(reader1 -> NetworkIntentPolicyConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrepareNetworkPoliciesRequest;
        });
    }
}

