/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class NetworkIntentPolicy
extends Resource {
    private String etag;
    private String id;
    private String type;
    private String name;

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public NetworkIntentPolicy withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public NetworkIntentPolicy withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkIntentPolicy withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static NetworkIntentPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkIntentPolicy)((Object)jsonReader.readObject(reader -> {
            NetworkIntentPolicy deserializedNetworkIntentPolicy = new NetworkIntentPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkIntentPolicy.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkIntentPolicy.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetworkIntentPolicy.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetworkIntentPolicy.withTags(tags);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetworkIntentPolicy.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedNetworkIntentPolicy.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkIntentPolicy;
        }));
    }
}

