/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.Direction;
import java.io.IOException;

public final class NetworkConfigurationDiagnosticProfile
implements JsonSerializable<NetworkConfigurationDiagnosticProfile> {
    private Direction direction;
    private String protocol;
    private String source;
    private String destination;
    private String destinationPort;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkConfigurationDiagnosticProfile.class);

    public Direction direction() {
        return this.direction;
    }

    public NetworkConfigurationDiagnosticProfile withDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public String protocol() {
        return this.protocol;
    }

    public NetworkConfigurationDiagnosticProfile withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String source() {
        return this.source;
    }

    public NetworkConfigurationDiagnosticProfile withSource(String source) {
        this.source = source;
        return this;
    }

    public String destination() {
        return this.destination;
    }

    public NetworkConfigurationDiagnosticProfile withDestination(String destination) {
        this.destination = destination;
        return this;
    }

    public String destinationPort() {
        return this.destinationPort;
    }

    public NetworkConfigurationDiagnosticProfile withDestinationPort(String destinationPort) {
        this.destinationPort = destinationPort;
        return this;
    }

    public void validate() {
        if (this.direction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property direction in model NetworkConfigurationDiagnosticProfile"));
        }
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model NetworkConfigurationDiagnosticProfile"));
        }
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model NetworkConfigurationDiagnosticProfile"));
        }
        if (this.destination() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destination in model NetworkConfigurationDiagnosticProfile"));
        }
        if (this.destinationPort() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinationPort in model NetworkConfigurationDiagnosticProfile"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeStringField("protocol", this.protocol);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("destination", this.destination);
        jsonWriter.writeStringField("destinationPort", this.destinationPort);
        return jsonWriter.writeEndObject();
    }

    public static NetworkConfigurationDiagnosticProfile fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkConfigurationDiagnosticProfile)jsonReader.readObject(reader -> {
            NetworkConfigurationDiagnosticProfile deserializedNetworkConfigurationDiagnosticProfile = new NetworkConfigurationDiagnosticProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("direction".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticProfile.direction = Direction.fromString(reader.getString());
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticProfile.protocol = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticProfile.source = reader.getString();
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticProfile.destination = reader.getString();
                    continue;
                }
                if ("destinationPort".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticProfile.destinationPort = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkConfigurationDiagnosticProfile;
        });
    }
}

