/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.Availability;
import com.azure.resourcemanager.network.models.Dimension;
import java.io.IOException;
import java.util.List;

public final class MetricSpecification
implements JsonSerializable<MetricSpecification> {
    private String name;
    private String displayName;
    private String displayDescription;
    private String unit;
    private String aggregationType;
    private List<Availability> availabilities;
    private Boolean enableRegionalMdmAccount;
    private Boolean fillGapWithZero;
    private String metricFilterPattern;
    private List<Dimension> dimensions;
    private Boolean isInternal;
    private String sourceMdmAccount;
    private String sourceMdmNamespace;
    private String resourceIdDimensionNameOverride;

    public String name() {
        return this.name;
    }

    public MetricSpecification withName(String name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MetricSpecification withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String displayDescription() {
        return this.displayDescription;
    }

    public MetricSpecification withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public MetricSpecification withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String aggregationType() {
        return this.aggregationType;
    }

    public MetricSpecification withAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    public List<Availability> availabilities() {
        return this.availabilities;
    }

    public MetricSpecification withAvailabilities(List<Availability> availabilities) {
        this.availabilities = availabilities;
        return this;
    }

    public Boolean enableRegionalMdmAccount() {
        return this.enableRegionalMdmAccount;
    }

    public MetricSpecification withEnableRegionalMdmAccount(Boolean enableRegionalMdmAccount) {
        this.enableRegionalMdmAccount = enableRegionalMdmAccount;
        return this;
    }

    public Boolean fillGapWithZero() {
        return this.fillGapWithZero;
    }

    public MetricSpecification withFillGapWithZero(Boolean fillGapWithZero) {
        this.fillGapWithZero = fillGapWithZero;
        return this;
    }

    public String metricFilterPattern() {
        return this.metricFilterPattern;
    }

    public MetricSpecification withMetricFilterPattern(String metricFilterPattern) {
        this.metricFilterPattern = metricFilterPattern;
        return this;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public MetricSpecification withDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Boolean isInternal() {
        return this.isInternal;
    }

    public MetricSpecification withIsInternal(Boolean isInternal) {
        this.isInternal = isInternal;
        return this;
    }

    public String sourceMdmAccount() {
        return this.sourceMdmAccount;
    }

    public MetricSpecification withSourceMdmAccount(String sourceMdmAccount) {
        this.sourceMdmAccount = sourceMdmAccount;
        return this;
    }

    public String sourceMdmNamespace() {
        return this.sourceMdmNamespace;
    }

    public MetricSpecification withSourceMdmNamespace(String sourceMdmNamespace) {
        this.sourceMdmNamespace = sourceMdmNamespace;
        return this;
    }

    public String resourceIdDimensionNameOverride() {
        return this.resourceIdDimensionNameOverride;
    }

    public MetricSpecification withResourceIdDimensionNameOverride(String resourceIdDimensionNameOverride) {
        this.resourceIdDimensionNameOverride = resourceIdDimensionNameOverride;
        return this;
    }

    public void validate() {
        if (this.availabilities() != null) {
            this.availabilities().forEach(e -> e.validate());
        }
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("aggregationType", this.aggregationType);
        jsonWriter.writeArrayField("availabilities", this.availabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableRegionalMdmAccount", this.enableRegionalMdmAccount);
        jsonWriter.writeBooleanField("fillGapWithZero", this.fillGapWithZero);
        jsonWriter.writeStringField("metricFilterPattern", this.metricFilterPattern);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isInternal", this.isInternal);
        jsonWriter.writeStringField("sourceMdmAccount", this.sourceMdmAccount);
        jsonWriter.writeStringField("sourceMdmNamespace", this.sourceMdmNamespace);
        jsonWriter.writeStringField("resourceIdDimensionNameOverride", this.resourceIdDimensionNameOverride);
        return jsonWriter.writeEndObject();
    }

    public static MetricSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (MetricSpecification)jsonReader.readObject(reader -> {
            MetricSpecification deserializedMetricSpecification = new MetricSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricSpecification.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMetricSpecification.displayName = reader.getString();
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedMetricSpecification.displayDescription = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricSpecification.unit = reader.getString();
                    continue;
                }
                if ("aggregationType".equals(fieldName)) {
                    deserializedMetricSpecification.aggregationType = reader.getString();
                    continue;
                }
                if ("availabilities".equals(fieldName)) {
                    List availabilities;
                    deserializedMetricSpecification.availabilities = availabilities = reader.readArray(reader1 -> Availability.fromJson(reader1));
                    continue;
                }
                if ("enableRegionalMdmAccount".equals(fieldName)) {
                    deserializedMetricSpecification.enableRegionalMdmAccount = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("fillGapWithZero".equals(fieldName)) {
                    deserializedMetricSpecification.fillGapWithZero = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("metricFilterPattern".equals(fieldName)) {
                    deserializedMetricSpecification.metricFilterPattern = reader.getString();
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedMetricSpecification.dimensions = dimensions = reader.readArray(reader1 -> Dimension.fromJson(reader1));
                    continue;
                }
                if ("isInternal".equals(fieldName)) {
                    deserializedMetricSpecification.isInternal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sourceMdmAccount".equals(fieldName)) {
                    deserializedMetricSpecification.sourceMdmAccount = reader.getString();
                    continue;
                }
                if ("sourceMdmNamespace".equals(fieldName)) {
                    deserializedMetricSpecification.sourceMdmNamespace = reader.getString();
                    continue;
                }
                if ("resourceIdDimensionNameOverride".equals(fieldName)) {
                    deserializedMetricSpecification.resourceIdDimensionNameOverride = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricSpecification;
        });
    }
}

